/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.maskat.framework.screendef.ButtonDef;
import org.maskat.framework.screendef.CheckboxDef;
import org.maskat.framework.screendef.CodeLibDef;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.ImageDef;
import org.maskat.framework.screendef.LabelDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.RadioDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.framework.screendef.TextDef;
import org.maskat.framework.screendef.TreeViewDef;
import org.maskat.framework.screendef.customize.IPluginComponentDef;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.MyXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.CodeLibFigure;
import org.maskat.ide.gef.figure.ImageFigure;
import org.maskat.ide.gef.figure.LayoutFigure;
import org.maskat.ide.gef.figure.MaskatGridFigure;
import org.maskat.ide.gef.figure.NullBorder;
import org.maskat.ide.gef.figure.SplitterFigure;

public class ComponentEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    static final Image CHECKBOXUNCHECKED = ComponentEditPart.createImage("/images/checkboxenabledoff.gif");
    static final Image RADIOUNCHECKED = ComponentEditPart.createImage("/images/radioboxenableoff.gif");
    static final Image COMBOBOXDROPDOWN = ComponentEditPart.createImage("/images/comboboxdropdown.gif");
    public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);
    public static Font BIG_FONT = new Font(null, "Arial", 12, 0);

    private static Image createImage(String name) {
        InputStream stream = ComponentEditPart.class.getResourceAsStream(name);
        Image image = new Image(null, stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return image;
    }

    public void activate() {
        super.activate();
        IComponentDef model = (IComponentDef)this.getModel();
        model.addPropertyChangeListener(this);
    }

    public void deactivate() {
        IComponentDef model = (IComponentDef)this.getModel();
        model.removePropertyChangeListener(this);
        super.deactivate();
    }

    protected IFigure createFigure() {
        IComponentDef model = (IComponentDef)this.getModel();
        IFigure figure = this.createFigure(model);
        XYLayout layout = new XYLayout();
        figure.setLayoutManager((LayoutManager)layout);
        return figure;
    }

    private IFigure createFigure(IComponentDef model) {
        Label label = null;
        if (model instanceof LabelDef) {
            label = new Label();
            label.setFont(DEFAULT_FONT);
            label.setBorder((Border)new NullBorder());
            label.setText(((LabelDef)model).getText());
        }
        if (model instanceof TextDef) {
            label = new Label();
            label.setFont(DEFAULT_FONT);
            label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(1)));
        }
        if (model instanceof ButtonDef) {
            label = new Label();
            label.setFont(DEFAULT_FONT);
            label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(1)));
            label.setText(((ButtonDef)model).getTitle());
            this.adjustModelPreferredSize((Figure)label, model);
        }
        if (model instanceof CheckboxDef) {
            CheckboxDef cd = (CheckboxDef)model;
            label = new Label(cd.getText(), CHECKBOXUNCHECKED);
            label.setFont(DEFAULT_FONT);
            label.setLabelAlignment(1);
            this.adjustModelPreferredSize((Figure)label, model);
        }
        if (model instanceof RadioDef) {
            RadioDef rd = (RadioDef)model;
            label = new Label(rd.getText(), RADIOUNCHECKED);
            label.setFont(DEFAULT_FONT);
            label.setLabelAlignment(1);
            this.adjustModelPreferredSize((Figure)label, model);
        }
        if (model instanceof ComboDef) {
            label = new Label("\u3000\u3000\u3000\u3000", COMBOBOXDROPDOWN);
            label.setFont(DEFAULT_FONT);
            label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
            label.setTextPlacement(8);
            label.setLabelAlignment(4);
        }
        if (model instanceof ImageDef) {
            label = new ImageFigure();
            label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
            this.adjustModelPreferredSize((Figure)label, model);
        }
        if (model instanceof CodeLibDef) {
            label = new CodeLibFigure();
            CodeLibDef codeLib = (CodeLibDef)model;
            model.setHeight(20);
            if (codeLib.hasLabelInput()) {
                ((CodeLibFigure)label).setWithLabelInput(true);
            } else {
                ((CodeLibFigure)label).setWithLabelInput(false);
            }
        }
        if (model instanceof GridDef) {
            MaskatGridFigure gridFigure = new MaskatGridFigure((GridDef)model);
            gridFigure.setFont(DEFAULT_FONT);
            gridFigure.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
            return gridFigure;
        }
        if (model instanceof TreeViewDef) {
            label = new Label("Tree View\n" + model.getName());
            label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(5)));
            label.setFont(BIG_FONT);
            return label;
        }
        if (model instanceof LayoutDef) {
            LayoutFigure figure = new LayoutFigure();
            return figure;
        }
        if (model instanceof IPluginComponentDef) {
            label = new Label();
            label.setBorder((Border)new LineBorder(1));
        }
        if (model instanceof IContainerDef && label == null) {
            label = new Label();
            label.setBorder((Border)new LineBorder(1));
        }
        if (label != null) {
            label.setOpaque(false);
        }
        if (label == null) {
            return new Figure();
        }
        return label;
    }

    private void adjustModelPreferredSize(Figure figure, IComponentDef model) {
        if (model instanceof ImageDef) {
            model.setWidth(20);
            model.setHeight(10);
            return;
        }
        Dimension dim = figure.getPreferredSize();
        model.setWidth(dim.width);
        model.setHeight(dim.height);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MaskatComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MyXYLayoutEditPolicy());
    }

    protected List getModelChildren() {
        List result = null;
        if (this.getModel() instanceof IContainerDef) {
            result = ((IContainerDef)this.getModel()).getUnmodifiableChildren();
        }
        if (this.getModel() instanceof GridDef) {
            result = ((GridDef)this.getModel()).getUnmodifiableChildren();
        }
        if (result != null) {
            return result;
        }
        return super.getModelChildren();
    }

    protected void refreshVisuals() {
        Rectangle constraint;
        IComponentDef comp = (IComponentDef)this.getModel();
        if (comp instanceof LabelDef) {
            constraint = ((Label)this.getFigure()).getTextBounds();
            constraint.x = comp.getLeft();
            constraint.y = comp.getTop();
            constraint.height = comp.getHeight();
            if (constraint.width == 0) {
                constraint.width = 25;
            }
        } else if (comp instanceof GridDef) {
            int tableWidth = ((GridDef)comp).headerTotalWidth();
            if (tableWidth <= 0) {
                tableWidth = 100;
            }
            constraint = new Rectangle(comp.getLeft(), comp.getTop(), tableWidth, comp.getHeight());
        } else {
            constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), comp.getHeight());
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    public Object getAdapter(Class key) {
        if (IPropertySource.class == key) {
            return null;
        }
        return super.getAdapter(key);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Iterator it;
        IComponentDef comp = (IComponentDef)this.getModel();
        if ("text".equals(evt.getPropertyName())) {
            if (comp instanceof LabelDef) {
                ((Label)this.getFigure()).setText((String)evt.getNewValue());
            }
            if (comp instanceof RadioDef) {
                ((Label)this.getFigure()).setText((String)evt.getNewValue());
            }
            if (comp instanceof GridDef) {
                this.getFigure().repaint();
            }
            if (comp instanceof CheckboxDef) {
                ((Label)this.getFigure()).setText((String)evt.getNewValue());
            }
        }
        if ("title".equals(evt.getPropertyName()) && comp instanceof ButtonDef) {
            ((Label)this.getFigure()).setText((String)evt.getNewValue());
        }
        if ("orientation".equals(evt.getPropertyName()) && comp instanceof SplitterDef) {
            ((SplitterFigure)this.getFigure()).repaint();
        }
        if (("gridHeaderTitle".equals(evt.getPropertyName()) || "gridHeaderWidth".equals(evt.getPropertyName()) || "lineHeight".equals(evt.getPropertyName())) && comp instanceof GridDef) {
            it = this.getChildren().iterator();
            while (it != null && it.hasNext()) {
                ((AbstractGraphicalEditPart)it.next()).refresh();
            }
            this.getFigure().repaint();
        }
        if ("boolWithLabel".equals(evt.getPropertyName()) && comp instanceof CodeLibDef) {
            ((CodeLibFigure)this.getFigure()).setWithLabelInput(((CodeLibDef)comp).hasLabelInput());
            this.getFigure().repaint();
        }
        if ("addChild".equals(evt.getPropertyName()) || "removeChild".equals(evt.getPropertyName())) {
            this.refreshChildren();
            if (comp instanceof GridDef) {
                it = this.getChildren().iterator();
                while (it != null && it.hasNext()) {
                    ((AbstractGraphicalEditPart)it.next()).refresh();
                }
                this.getFigure().repaint();
            }
        }
        this.refreshVisuals();
    }

    protected boolean switchNamedComponentVisibility(AbstractGraphicalEditPart editPart, String name, boolean firstOnly) {
        List children = editPart.getChildren();
        if (children == null) {
            return false;
        }
        boolean found = false;
        Iterator it = children.iterator();
        while (it != null && it.hasNext()) {
            IFigure figure;
            AbstractGraphicalEditPart child = (AbstractGraphicalEditPart)it.next();
            Object model = child.getModel();
            if (model instanceof IComponentDef && name.equals(((IComponentDef)model).getName()) && (figure = child.getFigure()) != null) {
                figure.setVisible(!figure.isVisible());
                found = true;
                if (firstOnly) {
                    return true;
                }
            }
            if (this.switchNamedComponentVisibility(child, name, firstOnly)) {
                found = true;
            }
            if (!found || !firstOnly) continue;
            return true;
        }
        return found;
    }
}

