/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.property.descriptor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.IParentAwareDef;
import org.maskat.ide.MaskatIDEUtil;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.property.ChildAppendableProperty;
import org.maskat.ide.property.descriptor.AddChildCommand;
import org.maskat.ide.view.MaskatEditView;

public abstract class ChildAppendablePropertyDescriptor
extends PropertyDescriptor {
    public ChildAppendablePropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        SelectCellEditor editor = new SelectCellEditor(parent, this);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    protected abstract IParentAwareDef createChild();

    private static class SelectCellEditor
    extends CellEditor {
        private Button button;
        private Object value = null;
        private ChildAppendablePropertyDescriptor descriptor;

        protected SelectCellEditor(Composite parent, ChildAppendablePropertyDescriptor descriptor) {
            super(parent, 0);
            this.descriptor = descriptor;
        }

        protected Control createControl(Composite parent) {
            this.button = new Button(parent, 1024);
            this.button.setText("+");
            this.button.setFont(parent.getFont());
            this.button.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        SelectCellEditor.this.fireCancelEditor();
                    }
                }
            });
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IEditorPart ep;
                    MaskatEditView editView = MaskatIDEUtil.getMaskatEditView();
                    if (editView != null && (ep = MaskatIDEUtil.getActiveEditor()) instanceof MaskatEditor) {
                        ((MaskatEditor)ep).editMode = 2;
                        try {
                            SelectCellEditor.this.startEdit((MaskatEditor)ep);
                        }
                        catch (PartInitException e) {
                            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"\u5b50\u30d7\u30ed\u30d1\u30c6\u30a3\u8ffd\u52a0\u51e6\u7406", (String)"\u5b50\u30d7\u30ed\u30d1\u30c6\u30a3\u8ffd\u52a0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)e.getStatus());
                        }
                    }
                }
            });
            this.setValueValid(true);
            return this.button;
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
            this.button.setFocus();
        }

        protected void doSetValue(Object value) {
            this.value = value;
        }

        private void startEdit(MaskatEditor ep) throws PartInitException {
            if (this.value != null && this.value instanceof ChildAppendableProperty) {
                ChildAppendableProperty hp = (ChildAppendableProperty)this.value;
                IParentAwareDef newChild = this.descriptor.createChild();
                CommandStack cs = (CommandStack)ep.getAdapter(CommandStack.class);
                AddChildCommand command = new AddChildCommand(hp, newChild);
                cs.execute((Command)command);
            }
        }
    }
}

