/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.property.descriptor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.ide.MaskatIDEUtil;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.property.ParamProperty;
import org.maskat.ide.property.ResultProperty;
import org.maskat.ide.view.MaskatEditView;

public class SelectPropertyDescriptor
extends PropertyDescriptor {
    public SelectPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        SelectCellEditor editor = new SelectCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public static class SelectCellEditor
    extends CellEditor {
        private Button button;
        private Object value = null;

        protected SelectCellEditor(Composite parent) {
            super(parent, 0);
        }

        protected Control createControl(Composite parent) {
            this.button = new Button(parent, 1024);
            this.button.setText("\u7de8\u96c6");
            this.button.setFont(parent.getFont());
            this.button.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        SelectCellEditor.this.fireCancelEditor();
                    }
                }
            });
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IEditorPart ep;
                    MaskatEditView editView = MaskatIDEUtil.getMaskatEditView();
                    if (editView != null && (ep = MaskatIDEUtil.getActiveEditor()) instanceof MaskatEditor) {
                        ((MaskatEditor)ep).editMode = 2;
                        try {
                            SelectCellEditor.this.startEdit((MaskatEditor)ep);
                        }
                        catch (PartInitException e) {
                            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"MaskatEdit\u30d3\u30e5\u30fc\u8868\u793a", (String)"MaskatEdit\u30d3\u30e5\u30fc\u8868\u793a\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)e.getStatus());
                        }
                    }
                }
            });
            this.setValueValid(true);
            return this.button;
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
            this.button.setFocus();
        }

        protected void doSetValue(Object value) {
            this.value = value;
        }

        private void startEdit(MaskatEditor ep) throws PartInitException {
            if (this.value != null) {
                if (this.value instanceof ParamProperty) {
                    ParamProperty pp = (ParamProperty)this.value;
                    MaskatIDEUtil.getMaskatEditView().showParam(pp, ep);
                }
                if (this.value instanceof ResultProperty) {
                    ResultProperty rp = (ResultProperty)this.value;
                    MaskatIDEUtil.getMaskatEditView().showResult(rp, ep);
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.maskat.ide.views.MaskatEditView");
            }
        }
    }
}

