package org.maskat.core.node;

import java.util.ArrayList;
import java.util.List;

/**
 * コンポジットノード
 * <pre>
 * 複数のノードをひとまとめにするノード
 * <code>
 * CompositeNode composite = new CompositeNode();
 * composite.add("tag1", "10").add("tag2", "20");
 * String xml = composite.getXML();
 * </code>
 * とすると、xmlは"&lt;tag1&gt;10&lt;/tag1&gt;&lt;tag2&gt;10&lt;/tag2&gt;"となる。
 * </pre>
 */
public class CompositeNode implements Node {

	private List children;
	
	public CompositeNode() {
		children = new ArrayList();
	}
	
	/**
	 * 子ノードの追加
	 * <pre>
	 * 戻り値でthisを返すため、
	 * <code>compositeNode.add(child1).add(child2);</code>
	 * と再起記述が可能。
	 * </pre>
	 * @param child 子ノード
	 * @return this
	 */
	public CompositeNode add(Node child) {
		children.add(child);
		return this;
	}
	
	/**
	 * 子ノードの追加
	 * <pre>
	 * ノード名とノード値指定の追加。
	 * <code>add(new LeafNode(nodeName, value));</code>
	 * と等価。
	 * </pre>
	 * @param nodeName ノード名
	 * @param value ノード値
	 * @return this
	 */
	public CompositeNode add(String nodeName, String value) {
		children.add(new LeafNode(nodeName, value));
		return this;
	}

	/**
	 * @see org.maskat.core.node.Node#getXML()
	 */
	public String getXML() {
		StringBuffer xml = new StringBuffer();
		for (int i = 0; i < children.size(); i++) {
			xml.append(((Node) children.get(i)).getXML());
		}
		return xml.toString();
	}
	
	
}