package org.maskat.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * maskatNGXg
 * @author pluswing
 */
public class MaskatRequest {
	
	private List children = new ArrayList();
	private final String key;
	private final String value;
	
	public MaskatRequest(String key, String value) {
		this.key = key;
		this.value = value;
	}
	
	public String getValue() {
		return value;
	}
	
	public String getKey() {
		return key;
	}
	
	public void add(MaskatRequest request) {
		children.add(request);
	}
	
	public List getChildren() {
		return children;
	}
	
	public MaskatRequest getChild(String key) {
		String[] keys = key.split("/");
		if (keys.length == 1) {
			return findChild(keys[0]);
		}
		MaskatRequest node = this;
		for (int i = 0; i < keys.length; i++) {
			node = node.getChild(keys[i]);
		}
		return node;
	}
	
	private MaskatRequest findChild(String key) {
		for (int i = 0; i < children.size(); i++) {
			MaskatRequest child = (MaskatRequest) children.get(i);
			if (child.getKey().equals(key)) {
				return child;
			}
		}
		return null;
	}
	
	public Iterator iterator() {
		return children.iterator();
	}
}
