package org.maskat.core;

import org.maskat.core.node.CompositeNode;
import org.maskat.core.node.LeafNode;
import org.maskat.core.node.Node;
import org.maskat.core.node.RootNode;
import org.maskat.core.node.TableNode;


/**
 * makatX|Xr_
 * @author pluswing
 */
public class MaskatResponseBuilder {

	private static final String HEADDER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
	private CompositeNode nodes = null;
	private final RootNode rootNode;

	MaskatResponseBuilder(String rootNodeName) {
		nodes = new CompositeNode();
		this.rootNode = new RootNode(rootNodeName, nodes);
	}
	
	public void add(String nodeName, String value) {
		nodes.add(new LeafNode(nodeName, value));
	}

	public void add(String nodeName, Node node) {
		nodes.add(new RootNode(nodeName, node));
	}

	public void add(Node node) {
		nodes.add(node);
	}
	
	public String getResponce() {
		return HEADDER + rootNode.getXML();
	}
	
	public static CompositeNode composite() {
		return new CompositeNode();
	}
	
	public static TableNode table(String tableName) {
		return new TableNode(tableName);
	}
	
}
