package org.maskat.core.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;

/**
 * ev[gWFl[^
 * @author pluswing
 */
public class MaskatTemplateGenerator {

	private static String srcPath;
	private static String xmlPath;
	private static String changeLine;
	
	public MaskatTemplateGenerator() throws FileNotFoundException, IOException {
	}

	public static void main(String[] args) throws SAXException, IOException {
		
		System.out.println("[Start] MaskatTemplateGenerator");

		loadPropertyValues(ClassLoader.getSystemResource("maskat.property").getPath());
		
		if (0 == args.length) { // Ȃꍇ xmlPath̃Cxgt@CׂĂΏ
			String[] eventFiles = getEventXmlFiles();
			for (int i=0; i < eventFiles.length; i++) {
				System.out.println("[Generate]" + eventFiles[i]);
				generate(eventFiles[i]);
			}
		} else {
			for (int i=0; i < args.length; i++) {
				System.out.println("[Generate]" + args[i]);
				generate(args[i]);
			}
		}
		
		System.out.println("[End] MaskatTemplateGenerator");
	}
	
	private static void loadPropertyValues(String propertyName) throws FileNotFoundException, IOException {
		Properties prop = new Properties();
		prop.load(new FileInputStream(propertyName));
		srcPath = (String) prop.get("generate.src.path");
		xmlPath = (String) prop.get("generate.xml.path");
		changeLine = (String) prop.get("generate.code.chageline");
	}
	
	private static String[] getEventXmlFiles() {
		File xmlDir = new File(xmlPath);
		File[] eventFiles = xmlDir.listFiles((new FilenameFilter() {
			public boolean accept(File dir, String name) {
				if(-1 != name.indexOf("_e.xml")) {
					return true;
				}
				return false;
			}
		}));
		
		String[] filePaths = new String[eventFiles.length];
		for (int i = 0; i < eventFiles.length; i++) {
			filePaths[i] = eventFiles[i].getAbsolutePath();
		}
		return filePaths;
		
	}
	
	private static void generate(String xmlpath) throws SAXException, IOException {
		
		BufferedReader reader = new BufferedReader(new FileReader(xmlpath));
		DOMParser parser = new DOMParser();
		parser.parse(new InputSource(reader));
		
		Document document = parser.getDocument();
		
		String packageName = getPacageName(document);
		ClassContent[] classes = getClassContents(document);
		
		if (generatePackage(packageName)) {
			for (int i = 0; i < classes.length; i++) {
				String content = generateClassContent(packageName, classes[i]);
				writeFile(packageName, classes[i].getClassName(), content);
			}
		} else {
			throw new IOException("pbP[W쐬Ɏs");
		}
	}
	
	private static String getPacageName(Document document) {
		NodeList headerList = document.getElementsByTagName("header");
		for (int i = 0; i < headerList.getLength(); i++) {
			Node node = headerList.item(i);
			if("maskat_layoutID".equals(node.getAttributes().getNamedItem("name").getTextContent())) {
				return node.getAttributes().getNamedItem("value").getTextContent();
			}
		}
		return "";
	}
	
	static class ClassContent {
		private String className;
		private List classMethods = new ArrayList();
		
		public void addClassMedhod(String name) {
			classMethods.add(name);
		}
		
		public String[] getClassMethosds() {
			return (String[]) classMethods.toArray(new String[classMethods.size()]);
		}

		public String getClassName() {
			return className;
		}

		public void setClassName(String className) {
			this.className = className;
		}
		
		public boolean hasMetod() {
			return 0 != classMethods.size();
		}
	}
	
	private static ClassContent[] getClassContents(Document document) {
		NodeList componentList = document.getElementsByTagName("component");
		List classContentList = new ArrayList(0);
		for (int i = 0; i < componentList.getLength(); i++) {
			ClassContent content = getClassContent(componentList.item(i));
			if (content.hasMetod()) {
				classContentList.add(content);
			}
		}
		return (ClassContent[]) classContentList.toArray(new ClassContent[classContentList.size()]);
	}
	
	private static ClassContent getClassContent(Node node) {
		
		ClassContent content = new ClassContent();
		
		content.setClassName(node.getAttributes().getNamedItem("id").getTextContent());
		
		NodeList children = node.getChildNodes();
		for (int i = 0; i < children.getLength(); i++) {
			Node child = children.item(i);
			if ("event".equals(child.getNodeName())) {
				if (null == child.getAttributes().getNamedItem("type") ||
						"remote".equals(child.getAttributes().getNamedItem("type").getTextContent())) {
					content.addClassMedhod(child.getAttributes().getNamedItem("id").getTextContent());
				}
			}
		}
		return content;
	}
	
	private static boolean generatePackage(String packageName) {
		if (null == packageName || "".equals(packageName)) {
			return true;
		}
		File current = new File(getFullPassByPackageName(packageName));
		if (current.exists()) {
			return true;
		}
		return current.mkdirs();
	}
	
	private static String generateClassContent(String packageName, ClassContent classContent) {
		StringBuffer buffer = new StringBuffer();
		buffer.append("package " + packageName + ";" + changeLine);
		buffer.append(changeLine);
		buffer.append("import org.maskat.core.MaskatRequest;" + changeLine);
		buffer.append("import org.maskat.core.MaskatResponseBuilder;" + changeLine);
		buffer.append(changeLine);
		buffer.append("public class " + classContent.getClassName() + " {" + changeLine);
		buffer.append(changeLine);
		String[] methods = classContent.getClassMethosds();
		for (int i = 0; i < methods.length; i++) {
			buffer.append("\tpublic void " + methods[i] + "(MaskatRequest request, MaskatResponseBuilder builder) {" + changeLine);
			buffer.append("\t\t// TODO ɏR[hLq" + changeLine);
			buffer.append("\t}");
		}
		buffer.append(changeLine);
		buffer.append("}");
		return buffer.toString();
	}
	
	private static void writeFile(String packageName, String className, String content) throws IOException {
		FileWriter writer = new FileWriter(getFullPassByPackageName(packageName) + "/" + className + ".java");
		writer.write(content);
		writer.close();
	}
	
	private static String getFullPassByPackageName(String packageName) {
		String directry = packageName.replace('.', '/');
		return srcPath + directry;
	}
}
