/**
 * 
 */
package org.maskat.core.node;

import java.util.ArrayList;
import java.util.List;


public class CompositeNode implements Node {
	private List children;
	public CompositeNode() {
		children = new ArrayList();
	}
	public CompositeNode add(Node child) {
		children.add(child);
		return this;
	}
	public CompositeNode add(String nodeName, String value) {
		children.add(new LeafNode(nodeName, value));
		return this;
	}
	public String getXML() {
		StringBuffer xml = new StringBuffer();
		for (int i = 0; i < children.size(); i++) {
			xml.append(((Node)children.get(i)).getXML());
		}
		return xml.toString();
	}
}