package org.maskat.core.node;


public class TableNode implements Node {

	private final String tableName;
	private CompositeNode currentRow = null;
	private CompositeNode rows = null;
	
	public TableNode(String tableName) {
		this.tableName = tableName;
		rows = new CompositeNode();
	}
	
	public CompositeNode newRow(String rowName) {
		currentRow = new CompositeNode();
		rows.add(new RootNode(rowName, currentRow));
		return currentRow;
	}
	
	public CompositeNode add(String colName, String value) {
		currentRow.add(new LeafNode(colName, value));
		return currentRow;
	}

	public String getXML() {
		return new RootNode(tableName, rows).getXML();
	}
}
