/**********************************************
***********************************************
*
*			MENU BAR
*
*
**********************************************/
maskat.widget.MenuBar = function(parent, objPar)
{
	this.menuEntriesArray 		= new Array();
	this.arrChild				= null;
	
	this.name					= "";
	
	// base constructor
	this.base	= rialto.widget.AbstractContainer;
	objPar.type	= "maskat.widget.MenuBar"
	this.base(objPar);
	
	this.title = "MenuBar";
	
	// default values Rialto/Menu
	this.widthEntry			= 100;
    this.resizable
    this.autoResizeContenu 	= false;    
    this.autoResizeParent 	= false;
    this.isClosable 		= false;
    this.draggableItem 		= false;
    
    
    // init values with the properties of the objPar object
    if (rialto.lang.isNumber(objPar.widthEntry))
    {
    	this.widthEntry
    }
    if (objPar && objPar.name != null)
	{
		this.name = objPar.name;
	}	
    
   	objPar = null;
    
    var oThis	= this;
    
	// *******************************************
	// GENERATION OF DOM ELEMENTS
	// *******************************************    
   	this.baseCSSClassName		= "maskat_widget_menu_bar";
    
	this.divExt.style.top		= "0px";
    this.divExt.style.left		= "0px";
    this.divExt.style.height	= "20";
    this.divExt.style.width		= "100%";                
	
	this.divExt.className		= this.baseCSSClassName;
/*	
	this.divEntries					= document.createElement("DIV");
	this.divEntries.id				= "DIV_MAINCONTAINER";
	this.divEntries.style.height	= "auto";
	this.divEntries.className		= this.baseCSSClassName + "_center";
	
	this.divExt.appendChild(this.divEntries);
*/	
	if (parent)
	{	
		this.placeIn(parent);
	}	
}

maskat.widget.MenuBar.prototype = new rialto.widget.AbstractContainer;

maskat.widget.MenuBar.prototype.add = function(newEntry, bValue)
{
	this.menuEntriesArray.push(newEntry);
//	this.divEntries.appendChild(newEntry.divExt);
	this.divExt.appendChild(newEntry.divExt);
	
	/* For Rialot remove() */
	this.arrChild = this.menuEntriesArray;	
} 

maskat.widget.MenuBar.prototype.removeEntry = function(entry)
{
	// ToDo
}

maskat.widget.MenuBar.prototype.getPath = function()
{
	return this.name;
}


/*********************************************************
*
*		MENU ANIMATION
*
**********************************************************/
maskat.widget.MenuBar.prototype.closeOpenMenus = function(activeMenuRef, event)
{
	for(var i = 0; i < this.menuEntriesArray.length; i++)
	{
		if (this.menuEntriesArray[i] != activeMenuRef)
		{
			this.menuEntriesArray[i].closeOpenMenu(event);
		}
	}
}

// maskat.widget.MenuContainer.prototype.adaptAfterSizeChange
// maskat.widget.MenuContainer.prototype.adaptToContext
// maskat.widget.MenuContainer.prototype.updateSize
// maskat.widget.MenuContainer.prototype.updateWidth
// maskat.widget.MenuContainer.prototype.updateHeight

/**********************************************************
*
*		REMOVING COMPONENT
*
**********************************************************/
maskat.widget.MenuBar.prototype.release = function()
{
	// Should remove all children
	// called in Rialot -> remove
}
/**********************************************
***********************************************
*
*			MENU ENTRY
*
*
**********************************************/
maskat.widget.MenuEntry = function(parentContainerObj, title, objPar)
{	
	// base constructor
	this.base	= rialto.widget.AbstractComponent;
	objPar.type	= "maskat.widget.Menu";
	
	this.base(objPar);

    this.parentContainerObj	= null;
	this.childContainerObj	= null;
	this.name				= "";
	
	// Values for server communication
/*	this.enabled				= true;*/
	this.visible				= true;
	this.value					= null;



/*	if(rialto.lang.isBoolean(objPar.enabled))
	{
		this.enabled	= objPar.enabled;
	}*/
	if(rialto.lang.isBoolean(objPar.visible))
	{
		this.visible	= objPar.visible;
	}
	if (objPar && objPar.value != null)
	{
		this.value = objPar.value;
	}
	
	// Default values rialto/Menu
	this.title				= title;
	this.enable 			= true;
	this.height				= "18px";
	this.widthMin			= "20px";
	this.width				= "auto";
		
	this.autoResizeParent 	= parent.autoResizeParent;   
    this.autoResizableH		= false;
    this.autoResizableW		= false; 
    	
	if(rialto.lang.isBoolean(objPar.enable))
	{
		this.enable	= objPar.enable;
	}
	if (objPar && objPar.name != null)
	{
		this.name = objPar.name;
	}	
	
	objPar 		= null;
	this.base 	= null;
	
	var oThis			= this;
	
	// *******************************************
	// GENERATION OF DOM ELEMENTS
	// *******************************************
	this.baseCSSClassName		= "maskat_widget_menu_entry_"
	
	if (window.opera)
	{
		this.top += 2; 
	}
	this.divExt.style.top		= this.top;
    this.divExt.style.left		= this.left;
    this.divExt.style.height	= this.height;
    this.divExt.style.minHeight = this.height;
    this.divExt.style.width		= this.width; 
    
    this.divExt.title			= this.title;   
	this.divExt.innerHTML		= this.title;
		
	this.divExt.onmouseover		= this.makeMouseOverFunc(oThis);
	this.divExt.onmouseout		= this.makeMouseOutFunc(oThis);
	this.divExt.onclick			= this.makeOnClickFunc(oThis);
	
	if (parentContainerObj)
	{
		this.parentContainerObj = parentContainerObj;
		this.placeIn(parentContainerObj);
	}
	
	this.updateVisibleDiv();
	this.updateEnabledDiv();
	
}

maskat.widget.MenuEntry.prototype = new rialto.widget.AbstractComponent;

maskat.widget.MenuEntry.prototype.add = function(containerObj, bValue)
{
	this.childContainerObj = containerObj;
}

/*********************************************************
*
*		GETTER/SETTER
*
**********************************************************/
maskat.widget.MenuEntry.prototype.getParent = function()
{
	return 	this.parentContainerObj;
}

maskat.widget.MenuEntry.prototype.getPath = function()
{
	parentPath	= this.getParent().getPath();
	path		= parentPath + "/" + this.name;

	return path
}

maskat.widget.MenuEntry.prototype.getTitle = function()
{
	return 	this.title;
}

maskat.widget.MenuEntry.prototype.setTitle = function(sValue)
{
	this.title = sValue;
	this.divExt.innerHTML	= this.title;
}

/*
maskat.widget.MenuEntry.prototype.getEnable = function()
{
	return 	this.enable;
}
*/

maskat.widget.MenuEntry.prototype.setEnable = function(bValue)
{
/*	this.enabled = bValue;*/
	this.enable  = bValue;
	this.updateEnabledDiv();
}
/*
maskat.widget.MenuEntry.prototype.getVisible = function()
{
	return 	this.visible;
}
*/
maskat.widget.MenuEntry.prototype.setVisible = function(bValue)
{
	this.visible = bValue;
	this.updateVisibleDiv();
}

maskat.widget.MenuEntry.prototype.getValue = function()
{
	return 	this.value;
}

maskat.widget.MenuEntry.prototype.setValue = function(value)
{
	this.value = value;
}


maskat.widget.MenuEntry.prototype.setMultiValue = function(mulVal) 
{
	path	= mulVal[0]["PATH"];
	title 	= mulVal[0]["TITLE"];
	enable	= mulVal[0]["ENABLE"];
	visible = mulVal[0]["VISIBLE"];
	value	= mulVal[0]["VALUE"];

	str = 	  "path:\t" 	+ path 		+ "\n" 
			+ "enable:\t" 	+ enable 	+ "\n"
			+ "title:\t" 	+ title 	+ "\n"
			+ "visible:\t" 	+ visible 	+ "\n"
			+ "value:\t"	+ value		+ "\n";

	if (enable == "true") 
	{	
		this.setEnable(true);
	}
	else if (enable == "false")
	{
		this.setEnable(false);
	}
	if (title != null)
	{
		this.setTitle(title);
	}
	
	if (visible == "true")
	{
		this.setVisible(true);
	}
	else if (visible == "false")
	{
		this.setVisible(false);
	}
	
	if (value != null)
	{
		this.setValue(value);
	}
};


MenuEntryGetData = {};

MenuEntryGetData.menuValue = {};

MenuEntryGetData.menuValue.make = function(obj, validator, sourceNode)
{
	if ( (obj == null) || !(obj instanceof maskat.widget.MenuEntry) )
	{
		throw new MaskatError({name: "menuEntryTeleMarker error",
                         message: "obj is not of type <MenuEntryGetValue.menuData>",
                         fileName: "MenuEntry.js",
                         functionName: "MenuEntryGetValue.menuValue.make"});
	}
		
	var valueToSend = obj.getValue(); 
	
	var menuValueXML 	 = "<value>" + valueToSend + "</value>";
	
	var nodeName = maskat.xpath(sourceNode, "@node");
	
	if (nodeName != null)
	{
		return "<" + nodeName + ">" + valueToSend + "</" + nodeName + ">";
	}
	else
	{
		return menuValueXML;
	}
}

ObjWrapper.registerTeleMaker("menuEntry.value", MenuEntryGetData.menuValue);


MenuEntryGetData.menuData = {};

MenuEntryGetData.menuData.make = function (obj, validator, sourceNode)
{
	if ( (obj == null) || !(obj instanceof maskat.widget.MenuEntry) )
	{
		throw new MaskatError({name: "menuDataTeleMarker error",
                        message: "obj is not of type <MenuEntryGetData.menuData>",
                        fileName: "MenuEntry.js",
                        functionName: "MenuEntryGetData.menuData.make"});

	}

	var path 		= obj.getPath();
	var visible 	= obj.isVisible();
	var enable		= obj.isEnable();
	var title 		= obj.getTitle();
	var value		= obj.getValue();

	var menuDataXML	=	"<path>" 		+ path 		+ "</path>" 	+ 
						"<enable>"		+ enable   + "</enable>" 	+
						"<title>" 		+ title 	+ "</title>" 	+
						"<visible>" 	+ visible 	+ "</visible>"  +
						"<value>"		+ value		+ "</value>";

	var nodeName = maskat.xpath(sourceNode, "@node");
	
	if (nodeName != null)
	{
		return "<" + nodeName + ">" + menuDataXML + "</" + nodeName + ">";
	}
	else
	{	
		return menuDataXML;
	}
}

ObjWrapper.registerTeleMaker("menuEntry.data", MenuEntryGetData.menuData);
/*********************************************************
*
*		MENU ANIMATION
*
**********************************************************/
maskat.widget.MenuEntry.prototype.hideEntry = function()
{
	this.divExt.className	= this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "enabled";
}

maskat.widget.MenuEntry.prototype.forceCloseMenu = function()
{
	this.hideEntry();
}

maskat.widget.MenuEntry.prototype.closeOpenMenu = function(event)
{
	if(this.childContainerObj != null)
	{				
		this.childContainerObj.menuItemContainerCloses(event);
	}
	else
	{
		this.updateEnabledDiv()
	}
}

maskat.widget.MenuEntry.prototype.updateVisibleDiv = function()
{
	if (this.visible == false)
	{
		this.divExt.style.display = "none";
	}
	else
	{
		this.divExt.style.display = "inline";
	}
}

maskat.widget.MenuEntry.prototype.updateEnabledDiv = function()
{
	if (this.enable == true)
	{
    	this.divExt.className	= this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "enabled";
	}
	else 
	{
    	this.divExt.className	= this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "disabled";
	}
}




/**********************************************************
*
*		EVENT HANDLING
*
**********************************************************/
maskat.widget.MenuEntry.prototype.makeMouseOverFunc = function (oThis)
{

	return function(e)
	{
		if(!e)
		{
			e = window.event;
		}
		
		/* close all other menu entries */
		oThis.parentContainerObj.closeOpenMenus(oThis, e);
		
		if (oThis.enable)
		{	
			if (!window.opera)
			{

			
			/*	tmpArray = document.getElementsByTagName("input");
				
				for (var i = 0; i < tmpArray.length; i++)
				{
					tmpArray[i].blur();
				}
				
				tmpArray = document.getElementsByTagName("textarea");
				
				for (var i = 0; i < tmpArray.length; i++)
				{
					tmpArray[i].blur();
				}*/
			}
			
			this.className	= oThis.baseCSSClassName + "focus" + " " + oThis.baseCSSClassName + "enabled";		
			
			if(oThis.childContainerObj)
			{
				offsetTop	= this.offsetHeight;				
				offsetLeft	= this.offsetLeft;
								
				oThis.childContainerObj.showContainer(offsetLeft, offsetTop);
			}
			
			oThis.onmouseover(e);
		}
	}
}

maskat.widget.MenuEntry.prototype.makeMouseOutFunc = function(oThis)
{
	return function(e)
	{
		if(oThis.enable)
		{
			if (!e)
			{
				e = window.event;
			}

			if(oThis.childContainerObj != null)
			{				
				oThis.childContainerObj.hideContainer(e);
			}
			else
			{
				this.className	= oThis.baseCSSClassName + "passive" + " " + oThis.baseCSSClassName + "enabled";
			}
		}
	}
}

maskat.widget.MenuEntry.prototype.makeOnClickFunc = function(oThis)
{
	return function(e)
	{			
		if (oThis.childContainerObj == null)
		{
			if (oThis.enable)
			{			
				oThis.onclick(e);
				
				stopEvent(e);	    
			}
			else
			{
				// Do nothing -> could show child popup box
			}
		}
	}
}



/**********************************************************
*
*		REMOVING COMPONENT
*
**********************************************************/
maskat.widget.MenuEntry.prototype.release = function()
{
	this.divExt.onmouseover	= null;
	this.divExt.onmouseout	= null;
	this.divExt.onclick		= null;	

	if (this.childContainerObj)
	{
		// true: container calls remove must not remove itself from DOM tree
		//       container will "cut line"
		this.childContainerObj.remove(true);
	}
}


/**********************************************
***********************************************
*
*			MENU POPUP BOX
*
*
**********************************************/
maskat.widget.MenuPopup = function(parentEntryObj, parentDiv, objPar)
{
	this.cssClassName		= "maskat_widget_menu_popup";
	this.menuEntriesArray 	= new Array();
	this.speratorArray		= new Array();
	
	/* needed for Rialto Remove */
	this.arrChild			= null;
	
	this.parentEntryObj	  	= parentEntryObj;
	this.parentDiv			= parentDiv;
	this.name				= "";

	this.childMenuItemContainerHasFocus	= false;
	this.closeMenu						= false;
	
	/*
	* showContainer
	* onuseout 
	*/
	this.containerVisible				= false;
	
	// base constructor
	this.base	= rialto.widget.AbstractContainer;
	objPar.type	= "maskat.widget.MenuPopup"
	this.base(objPar);
	
	// default values Rialto/Menu
	this.widthEntry			= 100;
	this.width				= 130;
    this.autoResizeContenu 	= false;
    this.autoResizeParent 	= false;
    this.isClosable 		= false;
    this.draggableItem 		= false;
    
    // set the value with the properties of the objPar object
    if (rialto.lang.isNumber(objPar.width))
    {
    	this.width = objPar.width
    }
    if (objPar && objPar.name != null)
	{
		this.name = objPar.name;
	}	
    
    objPar 		= null;
  
	var oThis	= this;
	
    // *******************************************
	// GENERATION OF DOM ELEMENTS
	// *******************************************
	this.divExt.style.top		= "0px";
    this.divExt.style.left		= "0px";
    this.divExt.style.width		= this.width + "px";            		
	this.divExt.className		= this.cssClassName;  
	
	this.divExt.onmouseover	= this.makeMouseOverFunc(oThis);
	this.divExt.onmouseout	= this.makeMouseOutFunc(oThis);
	
	if (parentEntryObj)
	{
		this.placeIn(parentEntryObj);
		parentDiv.appendChild(this.divExt);
	}	  
}

maskat.widget.MenuPopup.prototype = new rialto.widget.AbstractContainer;

maskat.widget.MenuPopup.prototype.add = function(newEntry, bValue)
{
	this.menuEntriesArray.push(newEntry);
	this.divExt.appendChild(newEntry.divExt);
	
	this.arrChild = this.menuEntriesArray;
}

maskat.widget.MenuPopup.prototype.addSeperator = function()
{
	seperator 	= new maskat.widget.MenuSeparator();
	
	this.speratorArray[this.speratorArray.length] = seperator;
	
	this.divExt.appendChild(seperator.domNode);
	
	seperator	= null;
}

maskat.widget.MenuPopup.prototype.removeEntry = function(entry)
{
	// ToDo
}


/*********************************************************
*
*		GETTER/SETTER
*
**********************************************************/
maskat.widget.MenuPopup.prototype.getParent = function()
{
	return this.parentEntryObj;
}

maskat.widget.MenuPopup.prototype.getPath = function()
{
	parentPath	= this.getParent().getPath();

	path		= parentPath + "/" + this.name;

	return path
}



/*********************************************************
*
*		MENU ANIMATION
*
**********************************************************/
maskat.widget.MenuPopup.prototype.showContainer = function(xPos, yPos)
{
	this.divExt.style.left 	= xPos;
	this.divExt.style.top	= yPos;	
	
	this.divExt.style.display = "block";

	var maxLength = 0;	
	
	for (var i = 0; i < this.menuEntriesArray.length; i++)
	{

		this.menuEntriesArray[i].showItem();

		if (this.menuEntriesArray[i].acceleratorDiv.offsetWidth > maxLength)
		{
			maxLength = this.menuEntriesArray[i].acceleratorDiv.offsetWidth;
		}
	}
	
	for (var i = 0; i < this.menuEntriesArray.length; i++)
	{
		this.menuEntriesArray[i].acceleratorDiv.style.width = maxLength + "px";
	}
	
	this.containerVisible = true;
}

maskat.widget.MenuPopup.prototype.hideContainer = function(e)
{
		if (this.childMenuItemContainerHasFocus == false)
		{
			this.divExt.onmouseout(e);
		}
}

maskat.widget.MenuPopup.prototype.menuItemContainerCloses = function(e)
{
	if (this.childMenuItemContainerHasFocus == false && this.containerVisible == true)
	{
		this.divExt.onmouseout(e);
	}
}

maskat.widget.MenuPopup.prototype.forceCloseMenu = function()
{
	this.closeMenu 				= true;
	
	this.divExt.style.display 	= "none";
	
	this.parentEntryObj.forceCloseMenu();
}

maskat.widget.MenuPopup.prototype.setChildMenuItemHasFocus = function(bHasFocus)
{
	this.childMenuItemContainerHasFocus = bHasFocus;
}

/**********************************************************
*
*		EVENT HANDLING
*
**********************************************************/
maskat.widget.MenuPopup.prototype.makeMouseOverFunc = function (oThis)
{
	return function(e)
	{
		if (oThis.parentEntryObj.type == "maskat.widget.MenuItem")
		{
			oThis.parentEntryObj.setChildContainerHasFocus (true);
		}

	}
}

maskat.widget.MenuPopup.prototype.makeMouseOutFunc = function(oThis)
{
	return function(e)
	{
		// TODO: rewrite so that not needed anymore
		// to avoid reapearing of menu after mouse click
		if (oThis.closeMenu == false)
		{
			/* 
				- needed for opera other wise menu will close before mouse can hover over
				- neede for IE other wise sub container will not close proper 
					because ...?
			*/
			this.style.display = "block";
		}
		
		oThis.closeMenu = false;
		
		if (oThis.childMenuItemContainerHasFocus == false)
		{
			if(maskat.menuUtilsObj.checkIfMouseIsOut(e, this, oThis) == true)
			{
				this.style.display = "none";
				
				if (oThis.parentEntryObj.type == "maskat.widget.MenuItem")
				{
					oThis.parentEntryObj.setChildContainerCloses (e);
				}
				else
				{
					oThis.parentEntryObj.hideEntry();		
				}
				
				oThis.containerVisible = false;
			}
			else
			{
				if (oThis.parentEntryObj.type == "maskat.widget.MenuItem")
				{
					oThis.parentEntryObj.setChildContainerHasFocus (true);	
				}
				else
				{
					// Do nothing
				}				
			}
		}
	}
}



/**********************************************************
*
*		REMOVING COMPONENT
*
**********************************************************/
maskat.widget.MenuPopup.prototype.release = function()
{
	this.divExt.onmouseover	= null;
	this.divExt.onmouseout	= null;
}


/**********************************************
***********************************************
*
*			MENU ITEM
*
*
**********************************************/
maskat.widget.MenuItem = function (parentContainerObj, title, objPar)
{		
	if (!objPar)
	{
    	var objPar={};
    	objPar.name="maskat.widget.MenuItem";
	}   
	
	if (!objPar.type)
	{
		objPar.type	= "maskat.widget.MenuItem";
	}
	
	// base constructor
	this.base	= rialto.widget.AbstractComponent;	
	this.base(objPar);
	
	this.parentContainerObj		= null;
	this.childContainerObj		= null;
	this.overInnerElement		= false;
	
	this.childContainerHasFocus = false;
	
	// Values for server communication
	this.visible				= true;
	this.value					= null;
	
	if (objPar && objPar.name != null)
	{
		this.name = objPar.name;
	}	
	if (objPar && objPar.visible != null)
	{
		this.visible = objPar.visible;
	}	
	if (objPar && objPar.value != null)
	{
		this.value = objPar.value;
	}
	
	// Default values Rialto/Menu
	this.sIcon			= "";
	this.sIconAct		= "";
	this.sIconDis		= "";
	this.sIconDisAct	= "";
	
	this.title				= title;
	this.enable 			= true;
	
	// IE will increase height to 18 and FF/O will increase above -> must be set to 18
	this.height				= "18px";  
	this.widthMin			= "300px";
	this.width				= "100%";
	
	this.autoResizeParent 	= parent.autoResizeParent;   
    this.autoResizableH		= false;
    this.autoResizableW		= false; 
    
    if(rialto.lang.isBoolean(objPar.enable))
	{
		this.enable	= objPar.enable;
	}

	if(rialto.lang.isString(objPar.sIcon))
	{
		this.sIcon		= objPar.sIcon;		
	}
	if(rialto.lang.isString(objPar.sIconDisabled))
	{
		this.sIconDis		= objPar.sIconDisabled;

		if (this.sIcon == "")
		{
			this.sIcon 		= this.sIconDisabled;
		}
	}
	else 
	{
		this.sIconDis 		= this.sIcon
	}
	
	if (this.sIcon != "" && this.sIconDis != "")
	{
		this.sIconPassive		= maskat.menuUtilsObj.getPasFileName(this.sIcon);
		this.sIconDisPassive	= maskat.menuUtilsObj.getPasFileName(this.sIconDis);
	}
	
	objPar 		= null;
	this.base 	= null;
	
	// *******************************************
	// GENERATION OF DOM ELEMENTS
	// *******************************************
	this.baseCSSClassName	= "maskat_widget_menu_item_";
	
	this.divExt.style.top		= this.top;
    this.divExt.style.left		= this.left;
    this.divExt.style.height	= this.height;
    this.divExt.style.width		= "auto"; //this.width; 
    
    this.divExt.title			= this.title;   
	
	
    if (this.sIcon == "" || this.sIconDisabled == "")	
    {
    	this.divLeftDummy			= document.createElement("DIV");
	    this.divLeftDummy.className	= this.baseCSSClassName + "left_div";
		this.divLeftDummy.innerHTML	= " ";		
		this.divExt.appendChild(this.divLeftDummy);
    }
    else
    {
    	this.divLeftActive				= document.createElement("IMG");
		this.divLeftActive.className	= this.baseCSSClassName + "left_img";
		this.divLeftActive.src			= this.sIconDis;
		this.divLeftActive.style.display = "none";
		
		this.divExt.appendChild(this.divLeftActive);
		
		this.divLeftPassive				= document.createElement("IMG");
		this.divLeftPassive.className	= this.baseCSSClassName + "left_img";
		this.divLeftPassive.src			= this.sIconPassive;
		this.divLeftPassive.style.display = "inline";

		this.divExt.appendChild(this.divLeftPassive);
    }

	
	this.divCenter				= document.createElement("DIV");
	this.divCenter.innerHTML	= " " + this.title + " ";
    this.divCenter.className	= this.baseCSSClassName + "center_div";
	this.divExt.appendChild(this.divCenter);
	
	this.divRight				= document.createElement("DIV");
    this.divRight.className		= this.baseCSSClassName + "right_div";
	this.divExt.appendChild(this.divRight);

	
	this.acceleratorDiv				= document.createElement("DIV");
	this.acceleratorDiv.innerHTML	= " ";
    this.acceleratorDiv.className	= this.baseCSSClassName + "accelerator_div";	
	this.divRight.appendChild(this.acceleratorDiv);
	
	this.dummyArrowDiv					= document.createElement("DIV");
	this.dummyArrowDiv.innerHTML			= " ";
    this.dummyArrowDiv.className			= "dummyDiv";	
    
    this.divRight.appendChild(this.dummyArrowDiv); 
    
	this.divArrowPassive			= null;	
	this.divArrowActive				= null;	

	var oThis = this;
	
	this.divExt.onmouseover	= this.makeMouseOverFunc(oThis);
	this.divExt.onmouseout	= this.makeMouseOutFunc(oThis);
	this.divExt.onclick		= this.makeOnClickFunc(oThis);
	
	if (parentContainerObj)
	{
		this.parentContainerObj = parentContainerObj
		this.placeIn(this.parentContainerObj);
	}
}

maskat.widget.MenuItem.prototype = new rialto.widget.AbstractContainer;

maskat.widget.MenuItem.prototype.add = function(containerObj, bValue)
{
	this.childContainerObj = containerObj;
	
	if (this.divArrowPassive == null)
	{
		this.divRight.removeChild(this.dummyArrowDiv);
		
		this.divArrowPassive			= document.createElement("IMG");
		this.divArrowPassive.src		= "menuImages/arrowOff.PNG";
		this.divArrowPassive.className	= this.baseCSSClassName + "arrow_div";
		this.divArrowPassive.style.display = "inline";
		
		this.divArrowActive				= document.createElement("IMG");
		this.divArrowActive.src			= "menuImages/arrowOn.PNG";
		this.divArrowActive.className	= this.baseCSSClassName + "arrow_div";
		this.divArrowActive.style.display = "none";
		
		this.divRight.appendChild(this.divArrowPassive);
		this.divRight.appendChild(this.divArrowActive);
	}
}

/*********************************************************
*
*		GETTER/SETTER
*
**********************************************************/
maskat.widget.MenuItem.prototype.name			= "";


maskat.widget.MenuItem.prototype.getParent = function()
{
	return this.parentContainerObj;
}

maskat.widget.MenuItem.prototype.getTitle = function()
{
	return this.title;
}

maskat.widget.MenuItem.prototype.setTitle = function(newTitle)
{
	this.title	= newTitle;
	this.divCenter.innerHTML	= this.title + " ";
}

maskat.widget.MenuItem.prototype.getPath = function()
{
	parentPath	= this.getParent().getPath();
	
	path		= parentPath + "/" + this.name;
	
	return path;
}

/*
maskat.widget.MenuItem.prototype.getEnable = function()
{
	
	return this.enable;
}
*/

maskat.widget.MenuItem.prototype.setEnable = function(bEnabled)
{
	if ((this instanceof maskat.widget.MenuItem)&& !(this instanceof maskat.widget.MenuCheckboxItem))
	{
		this.enable  = bEnabled;
		this.updateEnabledDiv();
	}
}

/*
// inhereted from Rialto
maskat.widget.MenuItem.prototype.isVisible = function()
{
	return this.visible;
}
*/

maskat.widget.MenuItem.prototype.setVisible = function(bVisible)
{
	this.visible = bVisible;
	this.updateVisibleDiv();
}


maskat.widget.MenuItem.prototype.getValue = function()
{
	return this.value;
}

maskat.widget.MenuItem.prototype.setValue = function(value)
{
	this.value = value;
}



/*********************************************************
*
*		MENU ANIMATION
*
**********************************************************/
maskat.widget.MenuItem.prototype.showItem = function()
{
	if (this.visible == true)
	{
		this.divExt.style.display = "block";
		this.updateEnabledDiv();
		
		if (!this.divLeftDummy)
		{
			this.divLeftActive.style.display 	= "none";
			this.divLeftPassive.style.display 	= "inline";
		}
	}
	else 
	{
		this.divExt.style.display = "none";
	}
}

/*
TODO: Rename function
*/
maskat.widget.MenuItem.prototype.setChildContainerCloses = function(e)
{
	this.childContainerHasFocus 	= false;

	this.divArrowPassive.style.display	= "inline";
	this.divArrowActive.style.display 	= "none";
	
	if (!this.divLeftDummy)
	{
		this.divLeftActive.style.display 	= "none";
		this.divLeftPassive.style.display 	= "inline";
	}
	
    this.divExt.className = this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "enabled";
	
	this.parentContainerObj.setChildMenuItemHasFocus(false);
	this.parentContainerObj.hideContainer(e);
}

maskat.widget.MenuItem.prototype.hideEntry = function()
{
   	this.divArrowPassive.style.display 	= "inline";
	this.divArrowActive.style.display 	= "none";	
	
	if (!this.divLeftDummy)
	{
		this.divLeftActive.style.display 	= "none";
		this.divLeftPassive.style.display 	= "inline";
	}
	
    this.divExt.className = this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "enabled";	
}

maskat.widget.MenuItem.prototype.forceCloseMenu = function()
{
	this.parentContainerObj.forceCloseMenu();
}

maskat.widget.MenuItem.prototype.setChildContainerHasFocus = function(hasFocus)
{
	this.childContainerHasFocus = hasFocus;
	this.parentContainerObj.setChildMenuItemHasFocus(true);
}

maskat.widget.MenuItem.prototype.getChildContainerHasFocus = function(hasFocus)
{
	return this.childContainerHasFocus;
}


maskat.widget.MenuItem.prototype.updateVisibleDiv = function()
{
	if (this.visible == false)
	{
		this.divExt.style.display = "none";
	}
}


maskat.widget.MenuItem.prototype.updateEnabledDiv = function()
{
	try
	{
		if (this.enable)
		{
	    	this.divExt.className = this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "enabled";		
			if (!this.divLeftDummy)
			{
				this.divLeftActive.src			= this.sIcon;
				this.divLeftPassive.src			= this.sIconPassive;
			}
		}
		else 
		{
	    	this.divExt.className		= this.baseCSSClassName + "passive" + " " + this.baseCSSClassName + "disabled";		
			if (!this.divLeftDummy)
			{
				this.divLeftActive.src			= this.sIconDis;
				this.divLeftPassive.src			= this.sIconDisPassive;
			}
		}
	}
	catch(err)
	{
		alert("Error in MenuItem.updateEnabledDiv " + err.description);
	}
}

maskat.widget.MenuItem.prototype.addAcceleratorStr = function(value)
{
	this.acceleratorDiv.innerHTML		= value;	
}



/**********************************************************
*
*		EVENT HANDLING
*
**********************************************************/
maskat.widget.MenuItem.prototype.makeMouseOverFunc = function (oThis)
{
	return function(e)
	{
		if (oThis.enable)
		{
			if (!oThis.divLeftDummy)
			{
				oThis.divLeftActive.style.display 	= "inline";
				oThis.divLeftPassive.style.display 	= "none";
			}
			
		    this.className = oThis.baseCSSClassName + "focus" + " " + oThis.baseCSSClassName + "enabled";
		    
			if (!e)
			{
				e = window.event;
			}
			
			if (oThis.childContainerObj != null)
			{	
			   	oThis.divArrowPassive.style.display = "none";
				oThis.divArrowActive.style.display 	= "inline";	
				
				offsetLeft	= this.offsetWidth - 5 + oThis.parentContainerObj.divExt.offsetLeft;				
				offsetTop	= this.offsetTop + oThis.parentContainerObj.divExt.offsetTop;
			
				oThis.childContainerObj.showContainer (offsetLeft, offsetTop);
			}
			
			oThis.onmouseover(e);
		}	
	}
}

maskat.widget.MenuItem.prototype.makeMouseOutFunc = function(oThis)
{
	return function(e)
	{
		if (oThis.enable)
		{
			if (maskat.menuUtilsObj.checkIfMouseIsOut(e, this, oThis) == true)
			{
							
				if (oThis.childContainerObj == null)
				{
					if (!oThis.divLeftDummy)
					{
						oThis.divLeftActive.style.display 	= "none";
						oThis.divLeftPassive.style.display 	= "inline";
					}
			    	this.className = oThis.baseCSSClassName + "passive" + " " + oThis.baseCSSClassName + "enabled";					
				}
				else
				{
					oThis.childContainerObj.hideContainer(e);
				}
			}
		}
	}
}

maskat.widget.MenuItem.prototype.makeOnClickFunc = function(oThis)
{
	return function(e)
	{
		if (oThis.childContainerObj == null)
		{
			if (oThis.enable)
			{
				oThis.forceCloseMenu();
				oThis.onclick(e);
				stopEvent(e);	    
			}
		}
		else
		{
			// Do nothing -> could show child popup box
		}
	}
}


/**********************************************************
*
*		REMOVING COMPONENT
*
**********************************************************/
maskat.widget.MenuItem.prototype.release = function()
{
	this.divExt.onmouseover	= null;
	this.divExt.onmouseout	= null;
	this.divExt.onclick		= null;	

	if (this.childContainerObj)
	{
		// true: container calls remove must not remove itself from DOM tree
		//       container will "cut line"
		this.childContainerObj.remove(true);
	}
}

maskat.widget.MenuItem.prototype.setMultiValue = function(mulVal) 
{
	path	= mulVal[0]["PATH"];
	title 	= mulVal[0]["TITLE"];
	enable	= mulVal[0]["ENABLE"];
	visible = mulVal[0]["VISIBLE"];
	checked = mulVal[0]["CHECKED"];
	value	= mulVal[0]["VALUE"];

	str = 	  "path:\t" 	+ path 		+ "\n" 
			+ "enable:\t" 	+ enable 	+ "\n"
			+ "title:\t" 	+ title 	+ "\n"
			+ "visible:\t" 	+ visible 	+ "\n"
			+ "checked:\t" 	+ checked	+ "\n"
			+ "value:\t"	+ value		+ "\n";
			
	if (enable == "true") 
	{	
		this.setEnable(true);
	}
	else if (enable == "false")
	{
		this.setEnable(false);
	}
	
	if (title != null)
	{
		this.setTitle(title);
	}
	
	if (visible == "true")
	{
		this.setVisible(true);
	}
	else if (visible == "false")
	{
		this.setVisible(false);
	}
	
	if (this instanceof maskat.widget.MenuCheckboxItem)
	{
		if (checked == "true")
		{
			this.setChecked(true);
		}
		else if (checked == "false")
		{
			this.setChecked(false)
		}
	}
	
	if (value != null)
	{
		this.setValue(value);
	}
};


MenuItemGetData = {};

MenuItemGetData.menuValue = {};

MenuItemGetData.menuValue.make = function(obj, validator, sourceNode)
{
	if ( (obj == null) || !(obj instanceof maskat.widget.MenuItem))
	{
		throw new MaskatError({name: "menuItemTeleMarker error",
                         message: "obj is not of type <MenuItemGetValue.menuData>",
                         fileName: "MenuItem.js",
                         functionName: "MenuItemGetValue.menuValue.make"});
	}
		
	var valueToSend = obj.getValue(); 
	
	var menuValueXML 	 = "<value>" + valueToSend + "</value>";
	
	var nodeName = maskat.xpath(sourceNode, "@node");
	
	if (nodeName != null)
	{
		return "<" + nodeName + ">" + valueToSend + "</" + nodeName + ">";
	}
	else
	{
		return menuValueXML;
	}
}

ObjWrapper.registerTeleMaker("menuItem.value", MenuItemGetData.menuValue);
ObjWrapper.registerTeleMaker("menuCheckboxItem.value", MenuItemGetData.menuValue);


MenuItemGetData.menuData = {};

MenuItemGetData.menuData.make = function (obj, validator, sourceNode)
{
	if ( (obj == null) || !(obj instanceof maskat.widget.MenuItem)  || !(obj instanceof maskat.widget.MenuItem))
	{
		throw new MaskatError({name: "menuDataTeleMarker error",
                        message: "obj is not of type <MenuItemGetData.menuData>",
                        fileName: "MenuItem.js",
                        functionName: "MenuItemGetData.menuData.make"});

	}

	var path 		= obj.getPath();
	var visible 	= obj.isVisible();
	var enable		= obj.isEnable();
	var title 		= obj.getTitle();
	var checked 	= "";
	
	if (obj instanceof maskat.widget.MenuCheckboxItem)
	{
	 	checked		= obj.getChecked();
	}
	
	var value		= obj.getValue();

	var menuDataXML	=	"<path>" 		+ path 		+ "</path>" 	+ 
						"<enable>"		+ enable   + "</enable>" 	+
						"<title>" 		+ title 	+ "</title>" 	+
						"<visible>" 	+ visible 	+ "</visible>"  +
						"<checked>"		+ checked	+ "</checked>"	+
						"<value>"		+ value		+ "</value>";

	var nodeName = maskat.xpath(sourceNode, "@node");
	
	if (nodeName != null)
	{
		return "<" + nodeName + ">" + menuDataXML + "</" + nodeName + ">";
	}
	else
	{	
		return menuDataXML;
	}
}

ObjWrapper.registerTeleMaker("menuItem.data", MenuItemGetData.menuData);
ObjWrapper.registerTeleMaker("menuCheckboxItem.data", MenuItemGetData.menuData);

/**********************************************
***********************************************
*
*			MENU CHECKBOX ITEM
*
*
**********************************************/
maskat.widget.MenuCheckboxItem = function (parentContainerObj, title, objPar)
{
	if (!objPar)
	{
    	var objPar={};
    	objPar.name="menuCheckBoxItem";
	}
	  
	objPar.type	= "maskat.widget.MenuCheckboxItem";
	
	this.base 	= maskat.widget.MenuItem;  
    this.base(parentContainerObj, title, objPar);
    
	this.checkFunc				= "";
   	this.checked				= true;
   	
   	if(rialto.lang.isBoolean(objPar.checked))
	{
		this.checked		= objPar.checked;
	}
	
	if(rialto.lang.isString(objPar.checkFunc))
	{
		this.checkFunc = objPar.checkFunc;
	}
	
	//release object	
	objPar=null;
	this.base=null;
	
/*	this.updateCheckedDiv();*/
}

maskat.widget.MenuCheckboxItem.prototype = new maskat.widget.MenuItem;

maskat.widget.MenuCheckboxItem.prototype.runCheckMethod = function(oThis)
{
	if (oThis.checkFunc != "")
	{
		returnValue = eval(oThis.checkFunc + "()");
		if (returnValue == true)
		{
			oThis.checked = !oThis.checked;
		}
		else
		{	
			// Do nothing
		}
	}
	else
	{
		oThis.checked = !oThis.checked;
	}
	oThis.updateCheckedDiv();
}

maskat.widget.MenuCheckboxItem.prototype.setChecked = function(checked)
{
	this.checked = checked;
	this.updateCheckedDiv();
}

maskat.widget.MenuCheckboxItem.prototype.getChecked = function()
{
	return this.checked;
}

maskat.widget.MenuCheckboxItem.prototype.isChecked = function()
{
	return this.checked;
}



maskat.widget.MenuCheckboxItem.prototype.showItem = function()
{
	if (this.visible == true)
	{
		this.divExt.style.display = "block";
		
		/* needed to set CSS class */
		this.updateEnabledDiv();
		this.updateCheckedDiv();
		
		if (!this.divLeftDummy)
		{
			this.divLeftActive.style.display 	= "none";
			this.divLeftPassive.style.display 	= "inline";
		}
	}
	else 
	{
		this.divExt.style.display = "none";
	}
}

maskat.widget.MenuCheckboxItem.prototype.updateCheckedDiv = function()
{
 	try
 	{
		if (this.checked == true)
		{
			this.divLeftActive.src	= this.sIcon;
			this.divLeftPassive.src	= this.sIconPassive;
		}
		else
		{
			this.divLeftActive.src	= this.sIconDis;
			this.divLeftPassive.src	= this.sIconDisPassive;			
		}
	}
	catch (err)
	{
		alert("Error in MenuCheckboxItem.updateCheckedDiv " + err.description);
	}
}


maskat.widget.MenuCheckboxItem.prototype.makeOnClickFunc = function(oThis)
{
	return function(e)
	{
		if (oThis.childContainerObj == null)
		{
			oThis.runCheckMethod(oThis);
			
			oThis.forceCloseMenu();
			oThis.onclick(e);
			stopEvent(e);	    
		}
		else
		{
			// Do nothing -> could show child popup box
		}
	}
}


/**********************************************
***********************************************
*
*			SEPERATOR
*
*
**********************************************/
maskat.widget.MenuSeparator = function()
{
	this.baseCSSClassName	= "maskat_widget_menu_seperator_"
	
	this.sizeSet = true;
	
	this.domNode = document.createElement("DIV");
	
	this.domNode.className = this.baseCSSClassName + "container";
	
	this.domNodeLeft 				= document.createElement("DIV");
	this.domNodeLeft.className 		= this.baseCSSClassName + "left";
	
	this.domNodeCenter 				= document.createElement("DIV");
	this.domNodeCenter.className 	= this.baseCSSClassName + "center";
	
	this.domNodeRight 				= document.createElement("DIV");
	this.domNodeRight.className 	= this.baseCSSClassName + "right";

	this.domNode.appendChild(this.domNodeLeft);	
	this.domNode.appendChild(this.domNodeCenter);
	this.domNode.appendChild(this.domNodeRight);

	this.adjustCenter = function()
	{
		leftWidth 	= this.domNodeLeft.offsetWidth;
		
		this.domNodeCenter.style.width = "100%";
		centerWidth = this.domNodeCenter.offsetWidth;
		
		rightWidth 	= this.domNodeRight.offsetWidth;

		this.domNodeCenter.style.width = centerWidth - (leftWidth + rightWidth);
	}
}



/**********************************************
***********************************************
*
*		    MASKAT EXTENSION: LAYOUT XML CODE 
*
*
**********************************************/
maskat.transMenuBarTag = function(pathObjArray, domElem)
{
	var output = "";
	var attr   = {};
	
	maskat.receiveAttributes(domElem, attr);
	
	var refObjName;
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
		if (pathObjArray[i].isContainer)
		{
			refObjName = pathObjArray[i].getRefObj();
			break;
		}
	}
	
	attr["parent"] = refObjName;

	var strObjPar = maskat.composeParam(domElem, attr);
	
	output += attr.name +	" = new maskat.widget.MenuBar("
						+	maskat.composeSingleParam(domElem, attr, "parent")	+ ", "
						+ 	strObjPar + ");\n";
	
	output += "layoutObj.components[\""+attr.name + "\"]="+attr.name+";\n";
	
	if (domElem.hasChildNodes())
	{
	  var mainMenuObj = new maskat.MenuBarClass(attr.name, attr.parent);
	  pathObjArray.push(mainMenuObj);
	
	  output += maskat.transChildNodes(pathObjArray, domElem);
	}
		
	return output;
}

maskat.MenuBarClass = function (name, parentRefName)
{
	this.name 			= name;
	this.parentRefName	= parentRefName;
}

maskat.MenuBarClass.prototype.isContainer = false;

maskat.MenuBarClass.prototype.getRefObj = function()
{ 
	return this.name; 
}
maskat.MenuBarClass.prototype.getParentRefObj = function()
{
	return this.parentRefName;
}


maskat.transMenuEntryTag = function(pathObjArray, domElem)
{
	var output = "";
	var attr = {};

	maskat.receiveAttributes(domElem, attr);
	
	var menuClassObj;
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
	  if (pathObjArray[i] instanceof maskat.MenuBarClass)
	  {
	    menuClassObj = pathObjArray[i];
	    break;
	  }
	}	

	if (menuClassObj == undefined)
	{
    	throw new MaskatError({
    						name: "layoutXML Syntax Error",
                           message: "menuEntry(name:'" + attr.name +"')の親要素としてmenuEntry要素がありません。",
                           fileName: "layoutXMLInterpreter.js",
                           functionName: "maskat.transMenuEntryTag"});
  	}
  	
  	var refObjName = menuClassObj.getRefObj();
  	
  	var strObjPar = maskat.composeParam(domElem, attr);
  	
  	attr["parent"] = refObjName;
  	
  	output += attr.name +	" = new maskat.widget.MenuEntry("
  						+	maskat.composeSingleParam(domElem, attr, "parent") + ", " 
  						+	maskat.composeSingleParam(domElem, attr, "caption")	+ ", "
  						+   strObjPar + ");\n";

	output += "layoutObj.components[\""+attr.name + "\"]="+attr.name+";\n";
	
	if (domElem.hasChildNodes())
	{
	   var menuEntryObj = new maskat.MenuEntryClass(attr.name);

	   pathObjArray.push(menuEntryObj);

	   output += maskat.transChildNodes(pathObjArray, domElem);
	}

	return output;
}

maskat.MenuEntryClass = function (name)
{
	this.name = name;
}
maskat.MenuEntryClass.prototype.isContainer = true;
maskat.MenuEntryClass.prototype.getRefObj = function()
{ 
	return this.name;
}


maskat.transMenuPopupTag = function(pathObjArray, domElem)
{
	var output = "";
	var attr = {};

	maskat.receiveAttributes(domElem, attr);
	
	var menuEntryClassObj;
	
	var menuBarClassObj;
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
	  if (pathObjArray[i] instanceof maskat.MenuBarClass)
	  {
	    menuBarClassObj = pathObjArray[i];
	    break;
	  }
	}	
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
	  if (pathObjArray[i] instanceof maskat.MenuEntryClass || pathObjArray[i] instanceof maskat.MenuItemClass)
	  {
	    menuEntryClassObj = pathObjArray[i];
	    break;
	  } 
	}
		
	if (menuEntryClassObj == undefined || menuBarClassObj == undefined)
	{
    	throw new MaskatError({
    			           name: "layoutXML Syntax Error",
                           message: "menuPopup(name:'" + attr.name +"')の親要素としてmenuPopup要素がありません。",
                           fileName: "layoutXMLInterpreter.js",
                           functionName: "maskat.transMenuPopupTag"});
  	}

  	var parentDivRefObjName		= menuBarClassObj.getParentRefObj(); 	
  	var parentEntryRefObjName	= menuEntryClassObj.getRefObj();
  	
    var strObjPar = maskat.composeParam(domElem, attr);
    
    attr["parent"] 			= parentDivRefObjName;
    attr["parentEntry"] 	= parentEntryRefObjName;

    output += attr.name +	" = new maskat.widget.MenuPopup("
  						+	maskat.composeSingleParam(domElem, attr, "parentEntry")	+ ", "
  						+	maskat.composeSingleParam(domElem, attr, "parent")	+ ", "  						
  						+   strObjPar + ");\n";
  						
	output += "layoutObj.components[\""+attr.name + "\"]="+attr.name+";\n";
		
  	if (domElem.hasChildNodes())
	{
	   var containerObj = new maskat.MenuPopupClass(attr.name);
	   pathObjArray.push(containerObj);
	   
	   output += maskat.transChildNodes(pathObjArray, domElem);
	}
	
	return output;
}

maskat.MenuPopupClass = function (name)
{
	this.name = name;
}

maskat.MenuPopupClass.prototype.isContainer = true;

maskat.MenuPopupClass.prototype.getRefObj = function()
{ 
	return this.name;
}


maskat.transMenuItemTag = function(pathObjArray, domElem)
{
	var output = "";
	var attr = {};

	maskat.receiveAttributes(domElem, attr);
	
	var containerClassObj;
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
	  if (pathObjArray[i] instanceof maskat.MenuPopupClass)
	  {
	    containerClassObj = pathObjArray[i];
	    break;
	  }
	}	

	if (containerClassObj == undefined)
	{
    	throw new MaskatError({
    					   name: "layoutXML Syntax Error",
                           message: "menuItem(name:'" + attr.name +"')の親要素としてmenuItem要素がありません。",
                           fileName: "layoutXMLInterpreter.js",
                           functionName: "maskat.transMenuItemTag"});
  	}
  	
  	var refObjName = containerClassObj.getRefObj();
  	
  	var strObjPar = maskat.composeParam(domElem, attr);
  	
  	attr["parent"] = refObjName;

  	output += attr.name +	" = new maskat.widget.MenuItem("
  						+	maskat.composeSingleParam(domElem, attr, "parent") + ", " 
  						+	maskat.composeSingleParam(domElem, attr, "caption")	+ ", "
  						+   strObjPar + ");\n";
  						
	output += "layoutObj.components[\""+attr.name + "\"]="+attr.name+";\n";
	
	if (domElem.hasChildNodes())
	{
	   var menuItemClassObj = new maskat.MenuItemClass(attr.name);
	   pathObjArray.push(menuItemClassObj);
	   
	   output += maskat.transChildNodes(pathObjArray, domElem);
	}
	
	return output;
}

maskat.MenuItemClass = function (name)
{
	this.name = name;
}
maskat.MenuItemClass.prototype.isContainer = true;
maskat.MenuItemClass.prototype.getRefObj = function()
{ 
	return this.name;
}

maskat.transMenuCheckboxItemTag = function(pathObjArray, domElem)
{
	var output = "";
	var attr = {};

	maskat.receiveAttributes(domElem, attr);
	
	var containerClassObj;
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
	  if (pathObjArray[i] instanceof maskat.MenuPopupClass)
	  {
	    containerClassObj = pathObjArray[i];
	    break;
	  }
	}	

	if (containerClassObj == undefined)
	{
    	throw new MaskatError({
    					   name: "layoutXML Syntax Error",
                           message: "menuCheckboxItem(name:'" + attr.name +"')の親要素としてmenuCheckboxItem要素がありません。",
                           fileName: "layoutXMLInterpreter.js",
                           functionName: "maskat.transMenuCheckboxItemTag"});
  	}
  	
  	var refObjName = containerClassObj.getRefObj();
  	
  	var strObjPar = maskat.composeParam(domElem, attr);
  	
  	attr["parent"] = refObjName;

  	output += attr.name +	" = new maskat.widget.MenuCheckboxItem("
  						+	maskat.composeSingleParam(domElem, attr, "parent") + ", " 
  						+	maskat.composeSingleParam(domElem, attr, "caption")	+ ", "
  						+   strObjPar + ");\n";
		
	output += "layoutObj.components[\""+attr.name + "\"]="+attr.name+";\n";
	
	return output;
}

maskat.MenuCheckboxItemClass = function (name)
{
	this.name = name;
}

maskat.MenuCheckboxItemClass.prototype.isContainer = false;
maskat.MenuCheckboxItemClass.prototype.getRefObj = function()
{ 
	return this.name;
}

maskat.transMenuSeparatorTag = function(pathObjArray, domElem)
{
	var output = "";
	var attr = {};
	
	maskat.receiveAttributes(domElem, attr);
	
	var conObj;
	
	for (var i = pathObjArray.length - 1; i >= 0; i--)
	{
		conObj = pathObjArray[i];
		if (conObj instanceof maskat.MenuPopupClass)
		{
			break;
		}
	}
	
	if (conObj == undefined)
	{
    	throw new MaskatError({
    						name: "layoutXML Syntax Error",
                           message: "menuSeperator(name:'" + attr.name +"')ã®è¦ªè¦ç´ ã¨ãã¦seperatorè¦ç´ ãããã¾ããã",
                           fileName: "layoutXMLInterpreter.js",
                           functionName: "maskat.transSeperatorTag"});
	}
	
	var refObjName	= conObj.getRefObj();
	
	var strObjPar 	= maskat.composeParam(domElem, attr);
	
	attr["parent"]	= refObjName;
	
	output += attr.name + " = " + attr["parent"] + ".addSeperator();\n"
	
    output += "layoutObj.components[\"" + attr.name + "\"]=" + attr.name + ";\n";
	
	return output;
}

maskat.syntax.menuBar = 
{
  	name:	{type: "string", req: true},
  	parent: {type: "object"}
};
  
maskat.syntax.menuEntry =
{
	name:		{type: "string", req: true},
	caption: 	{type: "string", req: true},
	parent:		{type: "object"},
    enable:		{type: "boolean"},    
    visible:  	{type: "boolean"},
	value:		{type: "string"}
};
  
maskat.syntax.menuPopup =
{
	name:			{type: "string", req: true},
	parent: 		{type: "object"},
	parentEntry:	{type: "object"},
	width: 			{type: "string"}
};
  
maskat.syntax.menuItem =
{
	name:    		{type: "string", req: true},
	caption:		{type: "string", req: true},
	parent:  		{type: "object"},
    enable:			{type: "boolean"},
    visible:  		{type: "boolean"},
	value:			{type: "string"},
	sIcon:			{type: "string"},
	sIconDisabled:	{type: "string"}
};

maskat.syntax.menuCheckboxItem =
{
	name:    		{type: "string", req: true},
	caption:		{type: "string", req: true},
	parent:  		{type: "object"},
    visible:  		{type: "boolean"},
	value:			{type: "string"},
	checked:		{type: "boolean"},
	checkFunc:		{type: "string"},
	sIcon:			{type: "string"},
	sIconDisabled:	{type: "string"}
};

maskat.syntax.menuSeparator = 
{
	name: {type: "string", req: true}
};

/**********************************************
***********************************************
*
*			KEY VECTOR
*
*
**********************************************/
maskat.widget.KeyVector	= function ()
{
	this.keys	= new Array();
	this.size	= 0;
}

maskat.widget.KeyVector.prototype.getSize = function()
{
	return this.size;
}

maskat.widget.KeyVector.prototype.addKey = function (newKey)
{
	var index = -1;
	if (this.indexOf(newKey) == -1)
	{
		this.keys.push(newKey);
		
		this.size 	= this.keys.length;
		index 		= this.keys.length;
	}

	return index;
}

maskat.widget.KeyVector.prototype.empty = function()
{
	while (this.keys.pop() != null)
	{
		// Do Nothing
	}
	
	this.size = this.keys.length;
}

maskat.widget.KeyVector.prototype.removeKey = function (key)
{
	var tmp = new Array();
	var e	= null;
	
	for (var i = 0; i < this.keys.length; i++)
	{
		if (this.keys[i] != key)
		{
			tmp.push(this.keys[i]);
		}
		else
		{
			e = key;
		}
	}
	
	this.keys = tmp;
	this.size = this.keys.length;
	
	return e;
}

maskat.widget.KeyVector.prototype.indexOf = function(key)
{
	for (var i = 0; i < this.keys.length; i++)
	{
		if (this.keys[i] == key)
		{
			return i;
		}
	}
	
	return -1;
}

maskat.widget.KeyVector.prototype.contains = function(key)
{
	for (var i = 0; i < this.keys.length; i++)
	{
		if (this.keys[i] == key)
		{
			return true;
		}
	}

	return false;
}

/**********************************************
***********************************************
*
*			KEY LOGGER
*
*
**********************************************/
maskat.widget.KeyLogger = function()
{
	this.type 		= "maskat.widget.KeyLogger";
	
	this.hasRunInit = false;
	
	this.keyObjMap 			= new Array();
	this.pressedKeysVector 	= new maskat.widget.KeyVector();
	
	this.oldOnKeyDown 	= function () {};
	this.oldOnKeyUp	 	= function () {};
	
	oThis = this;
}

maskat.keyLoggerObj = new maskat.widget.KeyLogger();


maskat.widget.KeyLogger.prototype.getHasRunInit = function()
{
	return this.hasRunInit;
}


maskat.widget.KeyLogger.prototype.upDateMenu = function(eventName, keyObj)
{
	var compStr 	= keyObj.getComponentAsStr();
	
	var accStr 		= keyObj.getAcceleratorAsString();
	
	eval
	(
		"if (" + compStr + ".type == \"maskat.widget.MenuItem\")" +
		"{" +
			compStr + ".addAcceleratorStr(\"" + accStr + "\");" +
		"}" +
		"else" +
		"{" +
			compStr + ".divExt.title += \" (\" + \"" + accStr + "\" + \")\";" +
		"}"
	);
}

maskat.widget.KeyLogger.prototype.KeyCode2Key = function (keyCode)
{
	key = "";
	keyLetter = "";
	
	/* [a..z], [A..Z]   upper/lower case will not be distinguished */
	if (keyCode > 64 && keyCode < 91)
   	{
		keyLetter = String.fromCharCode(keyCode);
   	}
   	else if (keyCode > 47 && keyCode < 58)  // [0, 1..9]
   	{
		keyLetter = String.fromCharCode(keyCode);
   	}
   	else
   	{
   		mapCode = "kc_" + keyCode;

   		if (maskat.widget.KeyLogger.Code2KeyMap[mapCode] != undefined)
   		{
   			keyLetter = maskat.widget.KeyLogger.Code2KeyMap[mapCode];
   		}
   	}
   	
   	return keyLetter;
}

maskat.widget.KeyLogger.prototype.makeOnKeyDownFunc = function (oThis)
{	
	return function (e)
	{
      	oThis.oldOnKeyDown(e);

    	var event		= window.event ? window.event : e;
    	var keyCode 	= event.keyCode;
    	
    	var keyLetter	= "";
    	 	
    	keyLetter = oThis.KeyCode2Key(keyCode);
    	
    	if (keyLetter != "")
    	{
	 	  	if (oThis.pressedKeysVector.indexOf(keyLetter) == -1)
	    	{
	    		oThis.pressedKeysVector.addKey(keyLetter);
	    	}
	    	else 
	    	{
	    		// Do nothing: key already stored
	    	}

	    	for (var i = 0; i < oThis.keyObjMap.length; i++)
	    	{
	    		var tmpKeyObj = oThis.keyObjMap[i];
	    		
	    		if (tmpKeyObj.checkIfComponentIsDeleted())
	    		{
	    			tmpKeyObj.removeFromKeyLogger();
	    		}
	    		else
	    		{
		    		if(tmpKeyObj.checkKeysPressed(event, oThis.pressedKeysVector))
					{
										
						oThis.pressedKeysVector.empty();
						tmpKeyObj.callEvent();
					}
				}
				
	    		/*
	    		var tmpStr = "";
	    		
	    		for (var j = 0; j < tmpKeyObj.metaKeysArray.length; j++)
	    		{
					tmpStr += tmpKeyObj.metaKeysArray[j] + " + ";
	    		}
	    		
	    		tmpStr += tmpKeyObj.key;
	    		*/
	    		
	    	}
	    	
		}
	}
}

maskat.widget.KeyLogger.prototype.makeOnKeyUpFunc = function (oThis)
{
	return function(e)
	{
      	oThis.oldOnKeyUp(e);
      	
      	var keyLetter = "";
      	
    	var event = window.event ? window.event : e;
    
    	keyLetter = oThis.KeyCode2Key(event.keyCode);
    	
    	oThis.pressedKeysVector.removeKey(keyLetter);
	}
}

maskat.widget.KeyLogger.prototype.initKeyLogging = function()
{
	if (document.onkeydown)
    {
    	this.oldOnKeyDown = document.onkeydown;
    }       
    document.onkeydown = this.makeOnKeyDownFunc(this);
    
    if (document.onkeyup)
    {
    	this.oldOnKeyUp = document.onkeyup;
    }
    document.onkeyup = this.makeOnKeyUpFunc(this);
    
   	this.hasRunInit = true;
}

maskat.widget.KeyLogger.Code2KeyMap = 
{
	kc_16: "SHIFT",
	kc_17: "CTRL",
	kc_18: "ALT"
/*	kc_112: "F1"....*/
};

maskat.widget.KeyLogger.prototype.connectEventKeyFunc = function(IDs, key, metaKey)
{
	var keyObj = new maskat.widget.KeyLogger.KeyObject(	key, 
														metaKey, 
														IDs.component, 
														IDs.event);
	
	this.keyObjMap.push(keyObj);
	
	this.upDateMenu(IDs.event, keyObj);
}

maskat.widget.KeyLogger.prototype.keyToString = function(event, eventName)
{
	var str =	eventName + ": ######################### \n" +
				"Key:\t\t"			+ String.fromCharCode(event.keyCode) + "\n" + 
				"Keycode:\t"		+ event.keyCode 	+ "\n" +
			  	"Charcode:\t" 		+ event.charCode	+ "\n" +
    		  	"Which:\t\t"		+ event.which		+ "\n" +
    		  	"event.altKey:\t"	+ event.altKey		+ "\n" +
    		  	"event.ctrlKey:\t"	+ event.ctrlKey		+ "\n" +
    		  	"event.shiftKey:\t"	+ event.shiftKey    + "\n" +
    		  	"Alt: " 			+ event.altKey 		+ " / "  + 
    		  	"Ctrl: " 			+ event.ctrlKey 	+ " / " + 
    		  	"Shift: " 			+ event.shiftKey;
    		  	
   return str;
}

maskat.widget.KeyLogger.prototype.removeZombies = function()
{
	var tmpArray = new Array();
	
	for (var i = this.keyObjMap.length - 1; i >= 0; i--)
   	{
   		var tmpKeyObj = this.keyObjMap.pop();
   		
   		if (tmpKeyObj.checkIfComponentIsDeleted())
   		{
   			tmpKeyObj.removeFromKeyLogger();
   		}
   		else
   		{
   			tmpArray.push(tmpKeyObj)
   		}
   	}
   	
   	this.keyObjMap = tmpArray;
}

maskat.widget.KeyLogger.prototype.removeKeyObj = function(keyObj)
{
	for (prop in keyObj)
	{
     	prop = null;
    }	
        
    delete keyObj
}

maskat.widget.KeyLogger.KeyObject = function (key, metaKeys, componentStr, eventStr)
{
	this.key			= null;
	
	this.checkAlt		= false;
	this.checkCtrl		= false;
	this.checkShift		= false;
	
	/* needed to update menu caption */
	this.metaKeysArray	= new Array();
	
	this.component  	= componentStr;
	this.method			= eventStr;
		
	if (key)
	{
		this.key 		= key.toUpperCase();
	}

	if (metaKeys)
	{
		var tmpArray	= new Array();
		var tempStr 	= "";
		
		// deleted spaces
		tempStr = metaKeys.replace(/\ /g, "");		
		
		// split string 		
		tmpArray = tempStr.split("|");
	
		for (var i = 0; i < tmpArray.length; i++)
		{
			tmpArray[i]	= tmpArray[i].toUpperCase();
			if (tmpArray[i] == "SHIFT")
			{
				this.checkShift = true;
			}
			else if (tmpArray[i] == "CTRL")
			{
				this.checkCtrl = true;
			}
			else if (tmpArray[i] == "ALT")
			{
				this.checkAlt = true;
			}
		}
		
		this.metaKeysArray = this.metaKeysArray.concat(tmpArray);
	}	
}

maskat.widget.KeyLogger.KeyObject.prototype.getAcceleratorAsString = function ()
{
	var tmpStr = "";
	    		
	for (var j = 0; j < this.metaKeysArray.length; j++)
	{
		tmpStr += this.metaKeysArray[j].substring(0, 1) + this.metaKeysArray[j].substring(1).toLowerCase() + "+";
	}
  		
	tmpStr += this.key;
		
	return tmpStr;
} 


maskat.widget.KeyLogger.KeyObject.prototype.checkKeysPressed = function(event, pressedKeysVector)
{
	keyPressed 		= false;
	modKeysPressed	= true; 
	
	keyPressed = pressedKeysVector.contains(this.key)
		
	if (this.checkShift == true && event.shiftKey == false)
	{
		modKeysPressed = false;
	}
		if (this.checkCtrl == true && event.ctrlKey == false)
	{
		modKeysPressed = false;
	}
	if (this.checkAlt == true && event.altKey == false)
	{
		modKeysPressed = false;
	}

	return (keyPressed == true && modKeysPressed == true);
}


maskat.widget.KeyLogger.KeyObject.prototype.callEvent = function()
{
	eval
	(
		"if (" + this.component + ".isVisible() && " + 
			     this.component + ".isEnable())" +
		"{" +
			this.component + "." + this.method + "();" + 
		"}"
	);
}

maskat.widget.KeyLogger.KeyObject.prototype.checkIfComponentIsDeleted = function()
{
	var tempComponent = eval(this.component);

	if (tempComponent.name == null) 
	{
		return true;
	}
	else
	{
		return false;
	}
}

maskat.widget.KeyLogger.KeyObject.prototype.removeFromKeyLogger = function ()
{
	return maskat.keyLoggerObj.removeKeyObj(this);
} 

maskat.widget.KeyLogger.KeyObject.prototype.getComponentAsStr = function ()
{
	return this.component;
} 

/**********************************************
***********************************************
*
*			MENU UTILS
*
*
**********************************************/
maskat.widget.MenuUtils = function(){};

maskat.menuUtilsObj = new maskat.widget.MenuUtils();

maskat.widget.MenuUtils.prototype.getMouseCoordinates = function(e, node, oThis)
{
	var offsetIE = 0;
	var	offsetO  = 0;
	var	offsetFF = 0;
		
	if (oThis.type == "maskat.widget.MenuPopup")
	{
		offsetIE = -2;
		offsetO  = 1;  // O reoprts correct values. To test against >=top the mouse pointer needs to be moved 1 down!
		offsetFF = 0;
	} 
	else if (oThis.type == "maskat.widget.MenuItem")
	{
		offsetIE = -3;
		offsetO  = 1;
		offsetFF = -1;		
	}

	if (window.opera)  // O
	{						
		mouseX 	= e.clientX + offsetO;
		mouseY 	= e.clientY + offsetO;
	}	
	else if (window.event) // IE
	{
		mouseX 	= window.event.clientX + offsetIE;
		mouseY 	= window.event.clientY + offsetIE;				
	}

	else  // FF
	{
		mouseX 	= e.clientX + offsetFF;
		mouseY 	= e.clientY + offsetFF;
	}
	
	return [mouseX, mouseY];
}

// TODO: Refactor!
maskat.widget.MenuUtils.prototype.checkIfMouseIsOut = function(e, node, oThis)
{
	mouseCoords = maskat.menuUtilsObj.getMouseCoordinates(e, node, oThis);
	
	mouseX = mouseCoords[0];
	mouseY = mouseCoords[1];


	nodePosition 	= this.getNodePosition(node);	

	leftXPos 		= nodePosition[0];
	topYPos  		= nodePosition[1];
	rightXPos		= leftXPos	+ node.offsetWidth;
	bottomYPos  	= topYPos 	+ node.offsetHeight;

/*			
 debug("MO(CO): " + oThis.name + " \n\t" + 
 	leftXPos 	+ " >= " + mouseX + " >= " + rightXPos + " / \n\t" + 
 	bottomYPos 	+ " <= " + mouseY + " <= " + topYPos);
*/
 /* In theory, the popup closes 1 pixel bevore mouse pointer is out
 		 <=top
 		-------
 		|     |
 <=left	|     | >=right
 		|     | 	
 		-------
 	    >=bottom
 */	    				
	if(mouseX <= leftXPos || mouseX >= rightXPos || mouseY <= topYPos || mouseY >= bottomYPos)
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**
*	From www.quirksmode.org
*/
maskat.widget.MenuUtils.prototype.getNodePosition = function(node)
{
	var curleft = curtop = borderWidth = 0;
	
	curleft	= node.offsetLeft
	curtop	= node.offsetTop
	
	if (node.offsetParent) 
	{
		while (node = node.offsetParent) 
		{
			curleft += node.offsetLeft
			curtop	+= node.offsetTop
		}
	}
	return [curleft, curtop, borderWidth];
}

maskat.widget.MenuUtils.prototype.getPasFileName = function(fileName)
{
	var sLenght 	= fileName.length;
	var fileBegin	= fileName.substr(0, sLenght - 4);
	var fileEnd		= fileName.substring(sLenght - 4);
	
	return fileBegin + "Passive" + fileEnd;
}


line = 0; 
function debug(text)
{
	debugText.setValue(line++ + ": " + text + "\n" + debugText.getValue().substr(0, 7000));
}