package org.maskat.demo.chatclient;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MyChatClientData
{
	/**
	 * @uml.property  name="hashMapUsers"
	 * @uml.associationEnd  qualifier="key:java.lang.Object java.lang.String"
	 */
	static Map<String, String> 	hashMapUsers	= new ConcurrentHashMap<String, String>();
	static List<MsgObject> 		listMsgQueue	= Collections.synchronizedList(
			new LinkedList<MsgObject>());
	
	public boolean addNewMsgToQueue(String[] newMsgArray)
	{
		MsgObject nMsgObj = new MsgObject(	newMsgArray[0], 
										  	newMsgArray[1], 
										  	hashMapUsers.values());
		
		System.out.println("\\\\ADDED MSG: " + nMsgObj.toString());
		
		return listMsgQueue.add(nMsgObj);
	}
	
	public void logUserIn(String[] newUser)
	{
		hashMapUsers.put(newUser[0], newUser[1]);
	}
	
	public String logUserOut(String[] userToLogout)
	{
		return (String)hashMapUsers.remove(userToLogout[0]);
	}
	
	
	public boolean checkUserAlreadyLoggedIn(String[] newUser)
	{
		boolean nickInUse = false,
				nameInUse = false;
		
		//System.out.println("Users logged in: " + hashMapUsers.size());
		
		nameInUse = hashMapUsers.containsKey(newUser[0]);
		nickInUse = hashMapUsers.containsValue(newUser[1]);
		
		if (nameInUse == true || nickInUse == true)
		{
			return true;
		}
		else 
		{		
			return false;
		}
	}

	public Map<String, String> getUsers()
	{
		return hashMapUsers;
	}

	public LinkedList<MsgObject> getMsgsForUser(String receiver)
	{
		LinkedList<MsgObject> msgsForUser = new LinkedList<MsgObject>();
		
		if (!listMsgQueue.isEmpty())
		{
			for(MsgObject msgObj : listMsgQueue)
			{	
				if(msgObj.isAddressedFor(receiver))
				{
					System.out.println("getMsgsForUser(String receiver): MSG ADDED TO QUEUE FOR CLIENT");
					msgsForUser.add(msgObj);
					msgObj.removeReceiver(receiver);
				}
			}
			return msgsForUser;
		}
		else
		{
			return null;
		}
	}

	public void cleanSentMsgs()
	{
		if(!listMsgQueue.isEmpty())
		{
			for(MsgObject msgObj : listMsgQueue)
			{
				if (!msgObj.isNotSend())
				{
					System.out.println("MSG COULD BE DELETED: " + listMsgQueue.indexOf(msgObj));
				}
			}
		}
		
	}
}
