package org.maskat.demo.chatclient;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author  Administrator
 */
public class UserManagementLogic
{
	MyChatClientData loginDataObject;
	/**
	 * @param loginDataObject  the loginDataObject to set
	 * @uml.property  name="loginDataObject"
	 */
	public void setLoginDataObject(MyChatClientData loginDataObject)
	{
		this.loginDataObject = loginDataObject;
		// TODO Auto-generated method stub
		
	}

	public boolean testUserData(String[] newUser)
	{
		return loginDataObject.checkUserAlreadyLoggedIn(newUser);
	}

	public boolean logUserIn(String[] newUser)
	{
		
		if(!loginDataObject.checkUserAlreadyLoggedIn(newUser))
		{
			loginDataObject.logUserIn(newUser);
			return true;
		}
		else
		{
			return false;
		}
	}

	public String getUsersAsXML()
	{
		Map<String, String> hashMapUsers = new ConcurrentHashMap<String, String>();
		
		StringBuffer strBuffer = new StringBuffer();
		
		hashMapUsers = loginDataObject.getUsers();
		
		//for (String user : (String[])hashMapUsers.keySet().toArray())
		Collection<String> users = hashMapUsers.values();
		Iterator iter = users.iterator();
		while(iter.hasNext())
		{
			String user = (String)iter.next();
			System.out.println("User to be logged in: " + user);
			strBuffer.append("\t\t<user>\n\t\t\t<nickname>");
				strBuffer.append(user);
			strBuffer.append("</nickname>\n\t\t</user>\n");
		}
		strBuffer.append("\t");
		return strBuffer.toString();
		
	}

	/**
	 * @return  the loginDataObject
	 * @uml.property  name="loginDataObject"
	 */
	public MyChatClientData getLoginDataObject()
	{
		return loginDataObject;
	}

	public String logUserOut(String[] userToLogout)
	{
		return loginDataObject.logUserOut(userToLogout);
	}
}
