package org.maskat.demo.menu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.maskat.demo.AbstractValueObj;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;

public class SampleServlet extends HttpServlet
{
	final String OP_PLUS 	= "+";
	final String OP_MINUS 	= "-";
	final String OP_MULT 	= "*";
	final String OP_DIV 	= "/";
	
	String resultXML = null;
	
	public double arg1 		= 0;

	public double arg2 		= 0;
	
	public String operator 	= "";

	public double result	= 0;
	
	private boolean enable;
	private boolean visible;
	private boolean checked;
	private String 	title 	= null,
					value	= null,
					path	= null;
	
	Object voObj = null;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 6169907056984915450L;
	public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		String requestURI = request.getRequestURI();

		request.setCharacterEncoding("UTF-8");
		
//		System.out.println(request.getLocalAddr());
		System.out.println(request.getRequestURI());  	// /mas/menudemo/add
		
		if (requestURI.endsWith("getdata"))
		{
			doTarget(request);
			resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><void></void>";
		} 
		else if (requestURI.endsWith("setdata"))
		{
			String actionType = getNodeValue(request, "type");
			
			if (actionType.equals("title"))
			{
				doTitleDemo(request);
			}
			else if (actionType.equals("enable"))
			{
				doEnableDemo(request);
			}
			else if (actionType.equals("visibility"))
			{
				doVisibilityDemo(request);
			}
			else if (actionType.equals("checked"))
			{
				doCheckedDemo(request);
			}
			else if (actionType.equals("value"))
			{
				doValueDemo(request);
			}
			else if (actionType.equals("entry"))
			{
				doEntryDemo(request);
			}
		}
		else if (requestURI.endsWith("value"))
		{
			doValueDemo(request);
		}
		else if (requestURI.endsWith("add"))
		{
			try 
			{
				String packageName = "org.maskat.demo.add.remote_equal";
				
				String eventID = request.getHeader("maskat_eventID");
					
				Class daoClass 	= Class.forName(packageName + ".DAO");
				Object daoObj	= daoClass.newInstance();
				
				Class voClass = Class.forName(packageName + ".vo.ValueObj");
				voObj = voClass.getConstructor(
						new Class[] { HttpServletRequest.class }).newInstance(
						new Object[] { request });
				
				daoClass.getMethod(eventID, new Class[] { AbstractValueObj.class })
				.invoke(daoObj, new Object[] { voObj });
			} 
			catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
//		DebugUtil.printRequestContent(request);
//		DebugUtil.printRequestHeaderInfo(request);

		response.setContentType("text/xml;charset=UTF-8");
		PrintWriter out = response.getWriter();
		AbstractValueObj avo = (AbstractValueObj) voObj;
	
		if (resultXML == "")
		{
			resultXML = avo.tempGetXML();
		}
		
		out.println(resultXML);
		System.out.println("�N���C�A���g�֑��M�d��:" + resultXML);
		
		resultXML = "";
	}

	private String getNodeValue(HttpServletRequest request, String nodeName)
	{
		BufferedReader reader;
		String action = "";
		try {
			reader = new BufferedReader(request.getReader());
			String line = null;
			String xml = "";
			while ((line = reader.readLine()) != null) {
				xml += line;
			}
			System.out.println("received XML: " + xml);
			if (xml != "")
			{
				DOMParser parser = new DOMParser();
				parser.parse(new InputSource(new StringReader(xml)));
	
				NodeList paramNodeList = parser.getDocument().getChildNodes().item(
						0).getChildNodes();
				
				for (int i = 0; i < paramNodeList.getLength(); i++) 
				{
					Node node = paramNodeList.item(i);
					if (nodeName.equals(node.getNodeName()))
					{
						action = node.getChildNodes().item(0).getNodeValue();
					}
					else if ("path".equals(node.getNodeName()))
					{
						path = node.getChildNodes().item(0).getNodeValue();
						System.out.println("Path received: " + path);
					}
					else if ("enable".equals(node.getNodeName()))
					{
						enable = new Boolean(node.getChildNodes().item(0).getNodeValue()).booleanValue();
						System.out.println("Enable received: " + enable);
					} 
					else if ("title".equals(node.getNodeName()))
					{
						title = node.getChildNodes().item(0).getNodeValue();
						System.out.println("Title received: " + title);
					}
					else if ("visible".equals(node.getNodeName()))
					{
						visible = new Boolean(node.getChildNodes().item(0).getNodeValue()).booleanValue();
						System.out.println("Visible received: " + visible);
					}
					else if ("checked".equals(node.getNodeName()))
					{
						if ( node.getChildNodes().item(0) != null )
						{
							checked = new Boolean(node.getChildNodes().item(0).getNodeValue()).booleanValue();
							System.out.println("Checked received: " + checked);
						}
						
					}
					else if ("value".equals(node.getNodeName()))
					{
						value = node.getChildNodes().item(0).getNodeValue();
						System.out.println("Value received: " + value);
					}
					
				}
			}
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return action;
	}


	private void doCheckedDemo(HttpServletRequest request)
	{				
		checked = !checked;
		
		resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" 
			+ "<menu>" 
				+ "<menuitem>" 
					+ "<data>" +
							"<path>"	+ "path to entry, may be used later"+ "</path>" 	+
							"<enable>"	+ "true" 		+ "</enable>" 	+
							"<title>" 	+ "New title" 		+ "</title>"	+
							"<visible>" + "false"           + "</visible>"	+
							"<checked>"	+ checked			+ "</checked>"	+
							"<value>"	+ "New value"		+ "</value>"
 					+ "</data>" 
				+ "</menuitem>" 
			+ "</menu>";
	}
	
	private void doVisibilityDemo(HttpServletRequest request)
	{		
		visible = !visible;
		
		resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" 
			+ "<menu>" 
				+ "<menuitem>" 
					+ "<data>" +
							"<path>" 	+ "path to entry, may be used later"+ "</path>" 	+
							"<enable>" 	+ "true/false" 		+ "</enable>" 	+
							"<title>" 	+ "New title" 		+ "</title>"	+
							"<visible>" + visible           	+ "</visible>"	+
							"<checked>" + "true/false"		+ "</checked>"	+
							"<value>"	+ "New value"		+ "</value>"
 					+ "</data>" 
				+ "</menuitem>" 
			+ "</menu>";
	}


	private void doEnableDemo(HttpServletRequest request)
	{
		enable = !enable;
	
		resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" 
			+ "<menu>" 
				+ "<menuitem>" 
					+ "<data>" +
							"<path>" 	+ "path to entry, may be used later"+ "</path>" 	+
							"<enable>" 	+ enable				+ "</enable>" 	+
							"<title>" 	+ "New title" 		+ "</title>"	+
							"<visible>" + "true/false"      + "</visible>"	+
							"<checked>" + "true/false"		+ "</checked>"	+
							"<value>"	+ "New value"		+ "</value>"
					+ "</data>" 
				+ "</menuitem>" 
			+ "</menu>";		
	}
	
	private void doValueDemo(HttpServletRequest request)
	{
		int newValue = Integer.parseInt(value);	

		
		resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" 
			+ "<menu>" 
				+ "<menuitem>" 
					+ "<data>" +
							"<path>" 	+ "path to entry, may be used later"	+ "</path>" 	+
							"<enable>" 	+ "true/false" 		+ "</enable>" 	+
							"<title>" 	+ "New title" 		+ "</title>"	+
							"<visible>" + "true/false"      + "</visible>"	+
							"<checked>" + "true/false"		+ "</checked>"	+
							"<value>"	+ ++newValue		+ "</value>"
					+ "</data>" 
				+ "</menuitem>" 
			+ "</menu>";
		
	}
	
	private void doTitleDemo(HttpServletRequest request)
	{		
		if (title.equals("New title"))
		{
			title = "Old title";
		}
		else
		{
			title = "New title";
		}
		
		resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" 
			+ "<menu>" 
				+ "<menuitem>" 
					+ "<data>" +
							"<path>" 	+ "path to entry, may be used later"	+ "</path>" 	+
							"<enable>" 	+ "true/false" 		+ "</enable>" 	+
							"<title>" 	+ title		 		+ "</title>"	+
							"<visible>" + "true/false"      + "</visible>"	+
							"<checked>"	+ "true/false"		+ "</checked>"	+
							"<value>"	+ "New value"		+ "</value>"
					+ "</data>" 
				+ "</menuitem>" 
			+ "</menu>";	
	}
	

	private void doEntryDemo(HttpServletRequest request)
	{
		int intValue = Integer.parseInt(value);
		
		String titleValue	= "Traget",
			   enableValue 	= "true",
			   visibleValue = "true";
		
		value = "" + ++intValue;
		
		if (intValue > 3)
		{
			titleValue	 = "Target";
			enableValue  = "true";
			visibleValue = "true";
			
			value 		= "0";
		}
		if (intValue == 1)
		{
			titleValue = "New Title";
		}
		if (intValue == 2)
		{
			enableValue = "false";
		}
		if (intValue == 3)
		{
			visibleValue = "false";
		}
		

		
		resultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" 
			+ "<menu>" 
				+ "<menuentry>" 
					+ "<data>" +
							"<path>" 	+ "path to entry, may be used later"	+ "</path>" 	+
							"<enable>" 	+ enableValue 		+ "</enable>" 	+
							"<title>" 	+ titleValue		+ "</title>"	+
							"<visible>" + visibleValue      + "</visible>"	+
							"<value>"	+ value				+ "</value>"
					+ "</data>" 
				+ "</menuentry>" 
			+ "</menu>";
		
	}

	public void doTarget(HttpServletRequest request)
	{
		BufferedReader reader;
		try {
			reader = new BufferedReader(request.getReader());
			String line = null;
			String xml = "";
			while ((line = reader.readLine()) != null) {
				xml += line;
			}
			System.out.println(xml);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
}