/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 検証エラー時にフロートメッセージを表示するLiveValidationクラスです。
 *
 * 本クラスでは一括検証時にフロートメッセージを表示せず、ダイアログAPIで
 * エラーメッセージを一括出力します。
 */
maskat.lang.Class.declare(
	"maskat.validator.livevalidation.custom.FloatAndAlertMessageLiveValidation")
	.extend("maskat.validator.livevalidation.custom.FloatMessageLiveValidation", {
	
	_static: {
	
		/**
		 * 複数項目の入力値の一括検証を行います。
		 *
		 * 本クラスでは、エラーメッセージをDialogでまとめて表示します。
		 *
		 * @param {Array} validations
		 *         検証対象となるLiveValidationオブジェクトの配列
		 * @return 検証結果
		 * @type boolean
		 */	
		massValidate: function(validations) {
			var returnValue = true;
			var messageArray = [];
			for(var i = 0, len = validations.length; i < len; ++i ){
				try {
					validations[i].isMassValidate = true;
					var valid = validations[i].validate(true);
					if(returnValue) returnValue = valid;
					if(!valid) {
						messageArray.push(validations[i].getMessage());
					}
				} finally {
					validations[i].isMassValidate = false;
				}
			}
			if(messageArray.length > 0) {
				maskat.ui.Dialog.openAlert("入力値検証エラー",
					messageArray.join("\n"), maskat.ui.Dialog.ERROR);
			}
			return returnValue;
		}
	},
	
	/**
	 * 検証エラー時の後処理(onInvalid)を設定します。
	 * 
	 * @param {object} options コンストラクタの第二引数(optionsObj)
	 */
	setOnInvalidFunction: function(options) {
		this.onInvalid = options.onInvalid || function(){
			if(!this.isMassValidate) {
				// 単項目チェック
				this.insertMessage( this.createMessageArea() );
			} else {
				// 一括チェック時
				this.removeMessage();
      		}
			this.addFieldClass();
		};
	},
	
	/**
	 * メッセージ文字列を取得します。
	 *
	 * バリデーション定義XMLのmessageタグに定義した内容を元に
	 * 下記の通り改行コードの処理をします。
	 *
	 * 即時検証: 改行文字(\n)をbrタグに変換します。
	 * 一括検証: 改行文字(\n)で文字列を改行します。
	 *
	 * @return 改行コードを処理したメッセージ文字列
	 * @type string
	 */
	getMessage: function() {
		if (this.isMassValidate) {
			return this.message.replace(/\\n/g, "\n");
		} else {
			return this.message.replace(/\\n/g, "<br />");
		}
	}
	
});
