/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.comm.HttpContext", {

	/** 通信ステータスを表す定数値の定義 */
	_static: {
		INIT: "init",
		READY: "ready",
		WAIT: "wait",
		COMPLETE: "complete",
		ERROR: "error",
		TIMEOUT: "timeout"
	},

	initialize: function(method, url, param){
		this.status = maskat.comm.HttpContext.INIT;
		
		this.url = url;
		this.method = method || "GET";
		this.async = param.async;
		this.sentAt = null;
		this.timeout = param.timeout? param.timeout : 0;
		this.requestHeaders = {};
		this.requestMessage = param.request;
		this.responseHeaders = [];
		this.responseMessage = "";
		this.error = null;
		
		this.requestHeaders["Content-Type"] = "application/xml";
		this.requestHeaders["If-Modified-Since"] = "Thu, 01 Jun 1970 00:00:00 GMT";

		var headers = param.headers;
		if (headers) {
			for (var i = 0; i < headers.length; i++) {
				this.requestHeaders[headers[i].name] = headers[i].value;
			}
		}
	},

	send: function() {
		maskat.comm.CommunicationManager.getInstance().enqueue(this);
	},

	setStatus: function(status) {
		if (this.status != status) {
			this.status = status;
			this.stateChanged();
		}
	},

	stateChanged: function(){
		switch (this.status) {
		case maskat.comm.HttpContext.WAIT:
			this.onWait();
			break;
		case maskat.comm.HttpContext.COMPLETE:
			this.onComplete();
			break;
		case maskat.comm.HttpContext.TIMEOUT:
			this.onTimeout();
			break;
		case maskat.comm.HttpContext.ERROR:
			this.onError();
			break;
		default:
			break;
		}
	},

	/**
	 * HTTP 要求を送信する直前に呼び出されるコールバックメソッドです。
	 */
	onWait: function(){
		/* NOP */
	},
	
	/**
	 * HTTP 応答を受信した直後に呼び出されるコールバックメソッドです。
	 */
	onComplete: function(){
		/* NOP */
	},
	
	/**
	 * HTTP 要求の応答待ちがタイムアウトした場合に呼び出されるコールバック
	 * メソッドです。
	 */
	onTimeout: function(){
		/* NOP */
	},

	/**
	 * 通信エラー発生時に呼び出されるコールバックメソッドです。
	 *
	 * このメソッドの実行時は、コンテキストの error プロパティで発生した
	 * エラーを参照することができます。
	 */
	onError: function(){
		/* NOP */
	},

	/**
	 * HTTP 要求の応答待ちがタイムアウトしているかどうかを返します。
	 *
	 * @return 応答待ちがタイムアウトしている場合は true
	 */
	isTimeout: function(){
		if (!this.sentAt || !this.timeout) {
			return false;
		}
		var now = (new Date()).getTime();
		return 	(now - this.sentAt) >= this.timeout;
	}
	
});


