/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.layout.Layout")
	.extend("maskat.layout.Widget", {

	initialize: function(layoutId){
		this.layoutId = layoutId;
		this.div = null;
		this.widgets = null;
		this.scope = window;
		this.children = null;
		this.listeners = null;
	},
	
	load: function(element, visible) {
		this.div = document.createElement("div");
		this.div.id = this.layoutId;
		element.appendChild(this.div);

		this.setVisible(false);
        this.accept(new maskat.layout.WidgetCreationVisitor(this));
		this.tabIndexes = this.createTabIndexes();
        
        if (visible) {
			this.setVisible(true);
		}

		this.notifyEvent("onload");
	},

	unload: function() {
		this.notifyEvent("onunload");
		this.setVisible(false);
        this.accept(new maskat.layout.WidgetDisposalVisitor());
	},

	setVisible: function(visible) {
		if (this.div && this.div.style) {
			this.div.style.visibility = visible ? "visible" : "hidden";
		}
	},

	addEventListener: function(listener) {
		if (!this.listeners) {
			this.listeners = [];
		}
		this.listeners.push(listener);
	},

	dispatchEvent: function(event) {
		if (!this.listeners) {
			return;
		}
		for (var i = 0; i < this.listeners.length; i++) {
			this.listeners[i].handleEvent(event);
		}
	},

	getWidget: function(widgetId) {
		return this.widgets[widgetId];
	},

	defineVariable: function(name, value) {
		if (name in this.scope) {
			throw new maskat.lang.Error("DUPLICATED_VARIABLE",
				{ layoutId: this.layoutId, name: name });	
		}
		this.scope[name] = value;
	},

	getVariable: function(name) {
		if (!(name in this.scope)) {
			throw new maskat.lang.Error("UNDEFINED_VARIABLE",
				{ layoutId: this.layoutId, name: name });	
		}
		return this.scope[name];
	},

	setVariable: function(name, value) {
		if (!(name in this.scope)) {
			throw new maskat.lang.Error("UNDEFINED_VARIABLE",
				{ layoutId: this.layoutId, name: name });	
		}
		this.scope[name] = value;
	},

	getWidgetId: function(){
		return this.layoutId;
	},

	getLayout: function(){
		return this;
	},
	
	getElement: function(){
		return this.div;
	},

	dispose: function() {
		this.div.parentNode.removeChild(this.div);
		delete this.div;
		delete this.tabIndexes;
	},
	
	createTabIndexes: function() {
		var list = [];
		for (prop in this.widgets) {
			var widget = this.widgets[prop]
			if (widget.getTabIndex() > -1 && widget.name) {
				list.push(widget);
			}
		}
		list.sort(function(a, b) {return a.getTabIndex() - b.getTabIndex()});
		var indexes = [];
		for (var i = 0; i < list.length; i++) {
			indexes.push(list[i].name);
		}
		return indexes;
	},
	
	getTabIndexes: function() {
		return this.tabIndexes;
	}
});
