/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.layout.WidgetCreationVisitor", {

	initialize: function(layout) {
		this.layout = layout;
		this.stack = [];
	},

	visit: function(widget) {
		var parent;
		if (this.stack.length > 0) {
			parent = this.stack[this.stack.length - 1];
		}
	
		widget.createWidget(parent);
		widget.setParent(parent);

		var widgetId = widget.getWidgetId();
		if (widgetId) {
			/* レイアウトにマスカット部品を登録 */
			if (!this.layout.widgets) {
				this.layout.widgets = {};
			}
			this.layout.widgets[widgetId] = widget;

			/* レイアウトにマスカット部品を登録 (マスカット 1.4.4 互換) */
			if (!this.layout.components) {
				this.layout.components = {};
			}
			this.layout.components[widgetId] = widget.getWidget();

			/* グローバル変数に Ajax 部品を登録 (マスカット 1.4.4 互換) */
			window[widgetId] = widget.getWidget();
		}

		this.stack.push(widget);
		return true;
	},
	
	postVisit: function(widget) {
		widget.postCreateWidget();
		this.stack.pop();
	}

});
