/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.log.SimpleLogFactory")
	.extend("maskat.log.LogFactory", {

	/**
	 * コンストラクタ
	 */
	initialize: function() {
		/* ログレベルの文字列 ("INFO", "DEBUG" 等) を取得 */
		this.defaultLevel = maskat.app.getProperty("maskat.log.default.level");
	},

	/**
	 * デフォルトのロガーオブジェクトを生成します。
	 *
	 * @param name ロガーオブジェクトの名前
	 */
	createLog: function(name) {
		/* ログレベルの文字列 ("INFO", "DEBUG" 等) を取得 */
		var level = maskat.app.getProperty("maskat.log." + name + ".level")
			|| this.defaultLevel;
		return new maskat.log.SimpleLog(name, maskat.log.Log[level]);
	}

});