/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.xml.CDATASectionBinding", {

	/**
	 * CDATA セクションに含まれる文字列を返します。
	 *
	 * @param object オブジェクト
	 * @param cdata CDATA セクションノード
	 */
	read: function(object, cdata) {
		return cdata.nodeValue;
	},

	/**
	 * オブジェクトを CDATA セクションの形式で文字列バッファに書き出します。
	 *
	 * @param object オブジェクト
	 * @param buffer 文字列バッファ
	 */
	write: function(object, buffer) {
		buffer.push("<![CDATA[" + object + "]]>");
	}

});
