/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.xml.XMLObjectBinder", {

	initialize: function(config, factory) {
		this.document = new maskat.xml.DocumentBinding(this);
		this.bindings = {
			"": {
				"#document": this.document,
				"#text": new maskat.xml.TextBinding(),
				"#cdata-section": new maskat.xml.CDATASectionBinding()
			}
		};
		this.addBindingConfiguration("", config);
		this.factory = factory;
	},

	addBindingConfiguration: function(uri, config){
		if (!config) {
			return;
		}

		uri = uri || "";
		for (var name in config) {
			if (name == "#document") {
				for (var root in config[name].children) {
					this.setRootElement(uri, root);
				}
			} else {
				this.addElementBinding(uri, name, config[name]);
			}
		}
	},

	setRootElement: function(uri, name) {
		this.document.setRootElement(uri, name);
	},

	getPrefix: function(uri) {
		for (var prefix in this.namespaces) {
			if (this.namespaces[prefix] == uri) {
				return prefix;
			}
		}
		return undefined;
	},

	addPrefixMapping: function(prefix, uri) {
		if (!this.namespaces) {
			this.namespaces = {};
		}
		this.namespaces[prefix] = uri;
	},

	getElementBinding: function(uri, name) {
		if (typeof(uri) == "object") {
			var qname = uri;
			uri = qname.namespaceURI;
			name = qname.localName || qname.baseName || qname.nodeName;
		}

		uri = uri || "";
		if (!this.bindings[uri]) {
			throw new maskat.lang.Error("UNKNOWN_NS_URI", { uri: uri });
		}
		if (!this.bindings[uri][name]) {
			throw new maskat.lang.Error("UNKNOWN_ELEMENT", { elementName: name });
		}
		return this.bindings[uri][name];
	},

	addElementBinding: function(uri, name, config) {
		uri = uri || "";
		var binding = new maskat.xml.ElementBinding(this, uri, name, config);
		if (!this.bindings[uri]) {
			this.bindings[uri] = {};
		}
		this.bindings[uri][name] = binding;
		return binding;
	},

	/**
	 * HTTP GET メソッドで取得した XML 文書の情報を オブジェクトに読み込み、
	 * そのオブジェクトを返します。
	 *
	 * @param url XML 文書の URL
	 *
	 * @return XML 文書の情報を読み込んだオブジェクト
	 */
	load: function(url) {
		try {
			return this.read(maskat.util.CrossBrowser.getXMLDocumentFrom(url));
		} catch (e) {
			throw new maskat.lang.Error("XML_LOAD_ERROR", { url: url }, e);
		}
	},

	/**
	 * XML 文書の情報をオブジェクトに読み込み、そのオブジェクトを返します。
	 *
	 * @param doc XML 文書
	 *
	 * @return XML 文書の情報を読み込んだオブジェクト
	 */
	read: function(doc) {
		return this.document.read(doc);
	},

	createObject: function(element) {
		return this.factory ? this.factory.create(element) : {};
	},

	/**
	 * オブジェクトを XML 文書の形式で文字列に書き出します。
	 *
	 * @param object オブジェクト
	 * @return XML 文書形式の文字列
	 */
	write: function(object) {
		var buffer = [];
		this.document.write(object, buffer);

		/* ルート要素に名前空間宣言を出力する */
		if (this.namespaces && buffer.length > 2) {
			var attributes = [];
			for (var prefix in this.namespaces) {
				attributes.push(" xmlns");
				if (prefix) {
					attributes.push(":");
					attributes.push(prefix);
				}
				attributes.push("=\"");
				attributes.push(this.namespaces[prefix]);
				attributes.push("\"");
			}
			buffer.splice(2, 0, attributes.join(""));
		}

		return buffer.join("");
	}

});
