/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * Abstract implementation of IContainerDef
 */
public abstract class AbstractContainer extends AbstractComponent implements Container {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#addChild(java.lang.Object)
	 */
	public void addChild(Object comp) {
		super.addChild(comp);
		// editpartでイベントを受け取ったら処理を。
		firePropertyChange("addChild", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#getComponentChildren()
	 */
	public List getComponents() {
		// こコンポーネントの名前
		Iterator componentsIt = this.getTypedChildren(AbstractComponent.class);
		if (componentsIt == null) {
			return Collections.EMPTY_LIST;
		}

		List result = new ArrayList();
		while (componentsIt.hasNext()) {
			result.add(componentsIt.next());
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#removeChild(java.lang.Object)
	 */
	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#addChildToIdx(java.lang.Object,
	 *      int)
	 */
	public void addChildToIdx(Object comp, int idx) {
		super.addChildToIdx(comp, idx);
		// editpartでイベントを受け取ったら処理を。
		firePropertyChange("addChild", "", null);
	}
}
