/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class Button extends AbstractComponent {

	public static final boolean ENABLE_DEFAULT = true;

	public static final boolean DRAGGABLE_DEFAULT = false;
	
	public static final boolean ADAPT_TO_TEXT_DEFAULT = true;
	
//	public static final String POSITION_DEFAULT = "absolute";
	
	public static final int WIDTH_DEFAULT = 88;
	
	public static final int WIDTH_MIN_DEFAULT = 88;

	public static final int TABINDEX_DEFAULT = -1;

	private String title;

	private String alt;

	private boolean enable = ENABLE_DEFAULT;
	
	private boolean adaptToText = ADAPT_TO_TEXT_DEFAULT;
	
//	private boolean draggable = DRAGGABLE_DEFAULT;
	
//	private String position = POSITION_DEFAULT;
	
	private int widthMin = WIDTH_MIN_DEFAULT;
	
	public Button() {
		setWidth(WIDTH_DEFAULT);
		setTabIndex(TABINDEX_DEFAULT);
	}

	public String getAlt() {
		return alt;
	}

	public void setAlt(String alt) {
		this.alt = alt;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		String oldTitle = this.title;
		this.title = title;
		firePropertyChange("title", oldTitle, title);
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public boolean isAdaptToText() {
		return adaptToText;
	}

	public void setConstraint(int left, int top, int width, int height) {
		if (this.adaptToText) {
			width = this.getWidth();
		}
		super.setConstraint(left, top, width, height);
	}
	
	public void setAdaptToText(boolean adaptToText) {
		boolean oldAdaptToText = this.adaptToText;
		this.adaptToText = adaptToText;
		firePropertyChange("adaptToText", String.valueOf(oldAdaptToText),
				String.valueOf(adaptToText));
	}

//	public boolean isDraggable() {
//		return draggable;
//	}

//	public void setDraggable(boolean draggable) {
//		this.draggable = draggable;
//	}

//	public String getPosition() {
//		return position;
//	}

//	public void setPosition(String position) {
//		this.position = position;
//	}

	public int getWidthMin() {
		return widthMin;
	}

	public void setWidthMin(int widthMin) {
		int oldMin = this.widthMin;
		this.widthMin = widthMin;
		firePropertyChange("widthMin", String.valueOf(oldMin),
				String.valueOf(widthMin));	
	}
	
	public String[] getEventTypes() {
		return new String[] {EventTypeConstants.ON_CLICK};
	}
}
