/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public class DivHtml extends AbstractComponent {
	
	public static final String CLASS_NAME_DEFAULT = "";
	
	public static final String POSITION_DEFAULT = "absolute";

	private String html;

	private String position = POSITION_DEFAULT;

	private String className = CLASS_NAME_DEFAULT;

	public String getHtml() {
		return html;
	}

	public void setHtml(String html) {
		String oldHtml = this.html;
		this.html = html;
		firePropertyChange("html", oldHtml, html);
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

}
