/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.layout.custom.ComponentLibrary;

public class MaskatComponentLibrary extends ComponentLibrary {

	public static final String prefix = "maskat";

	public static final String namespaceURI = "http://maskat.sourceforge.jp/core/layout/1.5.0/";

	public MaskatComponentLibrary() {
		super(prefix, namespaceURI);
		registerComponentType("alert", Alert.class);
		registerComponentType("button", Button.class);
		registerComponentType("checkbox", Checkbox.class);
		registerComponentType("codeLib", CodeLib.class);
		registerComponentType("combo", Combo.class);
		registerComponentType("comboItem", ComboItem.class);
		registerComponentType("divHtml", DivHtml.class);
		registerComponentType("divSplit", DivSplit.class);
		registerComponentType("frame", Frame.class);
		registerComponentType("grid", Grid.class);
		registerComponentType("gridCellCombo", GridCellCombo.class);
		registerComponentType("gridHeader", GridHeader.class);
		registerComponentType("gridLine", GridLine.class);
		registerComponentType("image", Image.class);
		registerComponentType("label", Label.class);
		registerComponentType("popup", Popup.class);
		registerComponentType("radio", Radio.class);
		registerComponentType("splitter", Splitter.class);
		registerComponentType("tabFolder", TabFolder.class);
		registerComponentType("tabItem", TabItem.class);
		registerComponentType("text", Text.class);
		registerComponentType("treeNode", TreeNode.class);
		registerComponentType("treeView", TreeView.class);
		registerComponentType("window", Window.class);
	}

}
