/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public class Splitter extends AbstractStructuredComponent {
	
	public static final String ORIENTATION_DEFAULT = "h";
	
	public static final String STYLE_DEFAULT = "normal";
	
//	public static final String MODE_LIM_DEFAULT = "%";
	
	public static final String OVERFLOW_DEFAULT = "hidden";
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final int TAILLECURS_DEFAULT = 4;
	
	public static final float PROP_DEFAULT = 0.5F;
	
	public static final float LIMINF_DEFAULT = 0F;
	
	public static final float LIMSUP_DEFAULT = 1F;
	
	public static final boolean AUTO_RESIZE_PARENT_DEFAULT = false;
	
//	public static final boolean AUTO_RESIZE_CONTENU_DEFAULT = false;
//	
	public static final boolean AUTO_RESIZABLE_H_DEFAULT = false;
	
	public static final boolean AUTO_RESIZABLE_W_DEFAULT = false;
	
	public static final boolean REVERSE_CLOSE_DEFAULT = false;

	public static final boolean WITH_IMG_DEFAULT = false;

	private String orientation = ORIENTATION_DEFAULT;

	private String style = STYLE_DEFAULT;

	private float prop = PROP_DEFAULT;

	private float limInf = LIMINF_DEFAULT;

	private float limSup = LIMSUP_DEFAULT;

	private boolean withImg = WITH_IMG_DEFAULT;

	private boolean reverseClose = REVERSE_CLOSE_DEFAULT;

	private boolean autoResizeParent = AUTO_RESIZE_PARENT_DEFAULT;

	private boolean autoResizableH = AUTO_RESIZABLE_H_DEFAULT;

	private boolean autoResizableW = AUTO_RESIZABLE_W_DEFAULT;

	private int tailleCurs = TAILLECURS_DEFAULT;

//	private boolean autoResizeContenu = AUTO_RESIZE_CONTENU_DEFAULT;

	private String overflow = OVERFLOW_DEFAULT;

//	private String modeLim = MODE_LIM_DEFAULT;
	
	private String position = POSITION_DEFAULT;
	
	private String onclick = "";

	/**
	 * 水平で分割するか
	 * 
	 * @return
	 */
	public boolean isHorizontal() {
		return "h".equalsIgnoreCase(orientation);
	}

	public boolean isAutoResizableH() {
		return autoResizableH;
	}

	public void setAutoResizableH(boolean autoResizebleH) {
		this.autoResizableH = autoResizebleH;
	}

	public boolean isAutoResizableW() {
		return autoResizableW;
	}

	public void setAutoResizableW(boolean autoResizebleW) {
		this.autoResizableW = autoResizebleW;
	}

	public boolean isAutoResizeParent() {
		return autoResizeParent;
	}

	public void setAutoResizeParent(boolean autoResizeParent) {
		this.autoResizeParent = autoResizeParent;
	}

	public int getTailleCurs() {
		return tailleCurs;
	}

	public void setTailleCurs(int tailleCurs) {
		this.tailleCurs = tailleCurs;
	}

	public float getLimInf() {
		return limInf;
	}

	public void setLimInf(float limInf) {
		this.limInf = limInf;
	}

	public float getLimSup() {
		return limSup;
	}

	public void setLimSup(float limSup) {
		this.limSup = limSup;
	}

	public String getOrientation() {
		return orientation;
	}

	/**
	 * スプリッタによって分割される方向を設定する。
	 * 
	 * @param orientation
	 *            v:垂直方向に分割される。 h:水平方向に分割される。
	 */
	public void setOrientation(String orientation) {
		this.orientation = orientation;
		firePropertyChange("orientation", "", null);
	}

	public float getProp() {
		return prop;
	}

	public void setProp(float prop) {
		this.prop = prop;
	}

	public boolean isReverseClose() {
		return reverseClose;
	}

	public void setReverseClose(boolean reverseClose) {
		this.reverseClose = reverseClose;
	}

	public String getStyle() {
		return style;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public boolean isWithImg() {
		return withImg;
	}

	public void setWithImg(boolean withImg) {
		this.withImg = withImg;
	}
	
	public String getOnclick() {
		return this.onclick;
	}
	
	public void setOnclick(String click) {
		this.onclick = click;
	}

//	public boolean isAutoResizeContenu() {
//		return autoResizeContenu;
//	}
//
//	public void setAutoResizeContenu(boolean autoResizeContenu) {
//		this.autoResizeContenu = autoResizeContenu;
//	}
//
//	public String getModeLim() {
//		return modeLim;
//	}
//
//	public void setModeLim(String modeLim) {
//		this.modeLim = modeLim;
//	}

	public String getOverflow() {
		return overflow;
	}

	public void setOverflow(String overflow) {
		this.overflow = overflow;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public boolean canAddPart(ComponentPart child) {
		return false;
	}
}
