/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.commands;

import org.eclipse.gef.commands.Command;

import org.maskat.core.layout.Grid;
import org.maskat.core.layout.GridHeader;

public class DelGridHeaderCommand extends Command {

	private Grid grid;

	private GridHeader header;

	private int idx;

	public DelGridHeaderCommand(Grid grid, GridHeader header) {
		this.grid = grid;
		this.header = header;
	}

	public void execute() {
		idx = grid.getChildIdx(header);
		if (idx == -1) {
			throw new IllegalStateException(
					"The component is not a child of the container.");
		}
		grid.removeChild(header);
	}

	public void undo() {
		grid.addChildToIdx(header, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
