/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.layout.CodeLib;
import org.maskat.core.layout.Component;
import org.maskat.ui.editors.layout.figures.CodeLibFigure;

public class CodeLibEditPart extends ComponentEditPart
	implements  HorizontalResizable {
	
	protected IFigure createFigure() {
		return new CodeLibFigure(((CodeLib) getModel()).hasLabelInput());
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				comp.getWidth(), d.height + 10);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("boolWithLabel".equals(evt.getPropertyName())) {
			((CodeLibFigure) getFigure()).setWithLabelInput(
					((CodeLib) getModel()).hasLabelInput());
			
			getFigure().repaint();
		}
//		refreshVisuals();
		super.propertyChange(evt);
	}
}
