/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Font;

import org.maskat.core.MaskatElement;
import org.maskat.core.layout.Combo;
import org.maskat.core.layout.ComboItem;
import org.maskat.core.layout.Component;
import org.maskat.ui.editors.layout.commands.AddBasicDefCommand;
import org.maskat.ui.editors.layout.editpolicies.ComboItemEditPolicy;
import org.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import org.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import org.maskat.ui.editors.layout.figures.ComboItemFigure;


public class ComboItemEditPart extends ComponentEditPart
	implements LabelDirectEditable {
		
	public static final int DEFAULT_HEIGHT = 20;
	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	public void activate() {
		this.addEditPartListener(new EditPartListener.Stub() {
			public void selectedStateChanged(EditPart part) {
				MaskatElement comboDef = ((ComboItem) ComboItemEditPart.this.getModel())
						.getParent();
				if (comboDef.getChildIdx(ComboItemEditPart.this.getModel()) == -1) {
					return;
				}
				/* 
				 * The comboItem has been removed from the parent,
				 * so don't refresh here.
				 * One refresh of editpart here will remove the editpart of
				 * comboitem from combo's, which should be the job of the
				 * DelComboItemCommand.
				 */
				if (part.getSelected() == SELECTED_NONE) {
					((ComboEditPart) ComboItemEditPart.this.getParent()).setShowChildren(false);
				} else {
					((ComboEditPart) ComboItemEditPart.this.getParent()).setShowChildren(true);
				}
				super.selectedStateChanged(part);
			}
		});
		Component model = (Component) getModel();
		model.addPropertyChangeListener(this);
		super.activate();
	}

	protected IFigure createFigure() {
		ComboItem ci = (ComboItem) getModel();
		return new ComboItemFigure(ci.getText());
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new ComboItemEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new DataBindingEditPolicy());
	}

	protected void refreshVisuals() {
		ComboItem ci = (ComboItem) getModel();
		((Label) getFigure()).setText(ci.getText());

		ComboEditPart ce = (ComboEditPart) this.getParent();
		Combo comboDef = (Combo) ce.getModel();
		Rectangle constraint = new Rectangle();

		int height = Math.max(comboDef.calcHeightItemInt(),
				ComboEditPart.MIN_HEIGHT_ITEM);
		int idx = comboDef.getChildIdx(this.getModel());
		constraint.setLocation(0, DEFAULT_HEIGHT + idx * height);

		constraint.setSize(comboDef.getWidth() - 1, height - 1);

		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),constraint);
	}

	public String getLabel() {
		return ((ComboItem) getModel()).getText();
	}

	public void setLabel(String text) {
		((ComboItem) getModel()).setText(text);
	}	
	
	public Command createConstrainCommand(EditPart editPart, Rectangle constraint) {
		return null;
	}
	
	public Command getCreateCommand(Object parent, Object node) {
		return  new AddBasicDefCommand((Combo) parent, (ComboItem) node);
	}
}
