/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;

import org.maskat.core.layout.Component;

import org.maskat.ui.editors.layout.figures.ButtonFigure;
import org.maskat.ui.editors.layout.figures.ImageFigure;

public class ImageEditPart extends ComponentEditPart
	implements  HorizontalResizable, VerticalResizable {
	
	protected IFigure createFigure() {
		Figure figure = new ImageFigure();
		return figure;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("title".equals(evt.getPropertyName())) {
			((ButtonFigure) getFigure()).setText((String) evt.getNewValue());
		}
//		refreshVisuals();
		super.propertyChange(evt);
	}

	protected void refreshVisuals() {
		adjustModelPreferredSize((Component) getModel());
		super.refreshVisuals();
	}
	
	private void adjustModelPreferredSize(Component model) {
		if (model.getWidth() == 0) {
			model.setWidth(16);
		}
		if (model.getHeight() == 0) {
			model.setHeight(16);
		}
	}
}
