/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;

public class SplitterFigure extends Label {

	public SplitterFigure() {
		setForegroundColor(ColorConstants.black);
		setLayoutManager(new XYLayout());
		setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
	}

	/**
	 * 指定されたインデックスのsplitPageだけを表示にする.
	 * 他のsplitPageは非表示にする
	 * 
	 * @param idx
	 */
	public void showSplitPage(int idx) {
		List childrenFigure = getChildren();
		int figureIdx = 0;
		for (Iterator it = childrenFigure.iterator(); it.hasNext();) {
			IFigure figure = (IFigure) it.next();
			if (figure instanceof DivSplitFigure) {
				if (((DivSplitFigure) figure).getIdx() == idx) {
					figure.setVisible(true);
				} else {
					figure.setVisible(false);
				}
				figureIdx++;
			}
		}
	}
}
