/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Splitter;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class SplitterPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_HEIGHT = "_prop_height_";
	
	public static final String PROP_AUTORESIZABLEH = "_prop_autoResizableH_";
	
	public static final String PROP_AUTORESIZABLEW = "_prop_autoResizableW_";
	
	public static final String PROP_AUTORESIZEPARENT = "_prop_autoResizeParent_";
	
	public static final String PROP_AUTORESIZECONTENU = "_prop_autoResizeContenu_";
	
	public static final String PROP_LIMINF = "_prop_limInf_";
	
	public static final String PROP_LIMSUP = "_prop_limSup_";
	
	public static final String PROP_MODELIM = "_prop_modeLim_";
	
	public static final String PROP_ORIENTATION = "_prop_orientation_";
	
	public static final String PROP_OVERFLOW = "_prop_overflow_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_PROP = "_prop_prop_";
	
	public static final String PROP_REVERSECLOSE = "_prop_reverseClose_";
	
	public static final String PROP_STYLE = "_prop_style_";
	
	public static final String PROP_TAILLECURS = "_prop_tailleCurs_";
	
	public static final String PROP_WITHIMG = "_prop_withImg_";
	
	public SplitterPropertySource(Splitter splitter) {
		super(splitter);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_HEIGHT, "height"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEH, "autoResizableH"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEW, "autoResizableW"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZEPARENT, "autoResizeParent"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZECONTENU, "autoResizeContenu"),
				  new MaskatTextPropertyDescriptor(PROP_LIMINF, "limInf"),
				  new MaskatTextPropertyDescriptor(PROP_LIMSUP, "limSup"),
//				  new MaskatTextPropertyDescriptor(PROP_MODELIM, "modeLim"),
				  new MaskatComboBoxPropertyDescriptor(PROP_ORIENTATION, "orientation", ComboBoxLabelConstants.SPLITTER_ORIENTATION),
				  new MaskatComboBoxPropertyDescriptor(PROP_OVERFLOW, "overflow", ComboBoxLabelConstants.SPLITTER_OVERFLOW),
//				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  new MaskatTextPropertyDescriptor(PROP_PROP, "prop"),
				  new BooleanComboBoxPropertyDescriptor(PROP_REVERSECLOSE, "reverseClose"),
				  new MaskatComboBoxPropertyDescriptor(PROP_STYLE, "style", ComboBoxLabelConstants.SPLITTER_STYLE),
				  new MaskatTextPropertyDescriptor(PROP_TAILLECURS, "tailleCurs"),
				  new BooleanComboBoxPropertyDescriptor(PROP_WITHIMG, "withImg")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_HEIGHT, "height");
	    propMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
	    propMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
	    propMap.put(PROP_AUTORESIZEPARENT, "autoResizeParent");
//	    propMap.put(PROP_AUTORESIZECONTENU, "autoResizeContenu");
	    propMap.put(PROP_LIMINF, "limInf");
	    propMap.put(PROP_LIMSUP, "limSup");
//	    propMap.put(PROP_MODELIM, "modeLim");
	    propMap.put(PROP_ORIENTATION, "orientation");
	    propMap.put(PROP_OVERFLOW, "overflow");
//	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_PROP, "prop");
	    propMap.put(PROP_REVERSECLOSE, "reverseClose");
	    propMap.put(PROP_STYLE, "style");
	    propMap.put(PROP_TAILLECURS, "tailleCurs");
	    propMap.put(PROP_WITHIMG, "withImg");

	}
}
