/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.masterdetails;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import org.maskat.ui.views.properties.tabbed.treenodewrapper.EventTreeNodeWrapper;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class EventBeansContentProvider implements ITreeContentProvider {

	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof ITreeNode) {
			return ((ITreeNode) parentElement).getChildren();
		}
		return null;
	}

	public boolean hasParent(Object element) {
		return false;
	}

	public Object getParent(Object element) {
		if (element instanceof ITreeNode) {
			return ((ITreeNode) element).getParent();
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		if (element instanceof ITreeNode) {
			return ((ITreeNode) element).hasChildren();
		}
		return false;
	}

	public void dispose() {
		// TODO Auto-generated method stub
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
//		this.viewer = viewer;
//		this.oldInput = oldInput;
//		this.newInput = newInput;
	}

	public Object[] getElements(Object inputElement) {
		return ((EventTreeNodeWrapper) inputElement).getElements();
	}
}
