/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.ParserSource;

class CharSequenceParserSource
implements ParserSource {
    private int lines = 1;
    private int columns = 1;
    private int offset = 0;
    private CharSequence cs;
    private StringBuilder cache = new StringBuilder(1000);

    public CharSequenceParserSource(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        this.cs = charSequence;
    }

    public int next() {
        if (this.offset < this.cs.length()) {
            char c;
            if ((c = this.cs.charAt(this.offset++)) == '\r' || c == '\n' && this.offset > 1 && this.cs.charAt(this.offset - 2) != '\r') {
                ++this.lines;
                this.columns = 0;
            } else {
                ++this.columns;
            }
            return c;
        }
        return -1;
    }

    public void back() {
        --this.offset;
        --this.columns;
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    public StringBuilder getCachedBuilder() {
        this.cache.setLength(0);
        return this.cache;
    }

    public String toString() {
        return ((Object)this.cs.subSequence(this.offset - this.columns + 1, this.offset)).toString();
    }
}

