/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONConvertException;
import net.arnx.jsonic.JSONParseException;
import net.arnx.jsonic.web.Container;
import net.arnx.jsonic.web.GatewayFilter;
import net.arnx.jsonic.web.Route;
import net.arnx.jsonic.web.RouteMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = -63348112220078595L;
    private Container container;
    private Config config;
    private List<RouteMapping> mappings = new ArrayList<RouteMapping>();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getInitParameter("config");
        if (string == null) {
            string = "";
        }
        JSON jSON = new JSON();
        try {
            this.config = jSON.parse((CharSequence)string, Config.class);
            if (this.config.container == null) {
                this.config.container = Container.class;
            }
            this.container = jSON.parse((CharSequence)string, this.config.container);
            this.container.init(this.getServletContext());
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (!this.config.definitions.containsKey(null)) {
            this.config.definitions.put(null, Pattern.compile("[^/()]+"));
        }
        if (this.config.mappings != null) {
            for (Map.Entry<String, String> entry : this.config.mappings.entrySet()) {
                this.mappings.add(new RouteMapping(entry.getKey(), entry.getValue(), this.config.definitions));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Route preprocess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        File file;
        String string = httpServletRequest.getContextPath().equals("/") ? httpServletRequest.getRequestURI() : httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        String string2 = this.config.encoding;
        Boolean bl = this.config.expire;
        GatewayFilter.Config config = (GatewayFilter.Config)httpServletRequest.getAttribute(GatewayFilter.GATEWAY_KEY);
        if (config != null) {
            if (string2 == null) {
                string2 = config.encoding;
            }
            if (bl == null) {
                bl = config.expire;
            }
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        if (bl == null) {
            bl = true;
        }
        if (string2 != null) {
            httpServletRequest.setCharacterEncoding(string2);
            httpServletResponse.setCharacterEncoding(string2);
        }
        if (bl != null && bl.booleanValue()) {
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", "Tue, 29 Feb 2000 12:00:00 GMT");
        }
        if ((file = new File(this.getServletContext().getRealPath(string))).exists()) {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    servletOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            return null;
        }
        for (RouteMapping routeMapping : this.mappings) {
            Route route = routeMapping.matches(httpServletRequest.getMethod(), string);
            if (route == null) continue;
            this.container.debug("route found: " + httpServletRequest.getMethod() + " " + string);
            return route;
        }
        httpServletResponse.sendError(404, "Not Found");
        return null;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Route route = this.preprocess(httpServletRequest, httpServletResponse);
        if (route == null) {
            return;
        }
        if ("rpc".equalsIgnoreCase((String)route.get("class"))) {
            httpServletResponse.addHeader("Allow", "POST");
            httpServletResponse.sendError(405, "Method Not Allowd");
            return;
        }
        this.doREST(route, httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Route route = this.preprocess(httpServletRequest, httpServletResponse);
        if (route == null) {
            return;
        }
        if ("rpc".equalsIgnoreCase((String)route.get("class"))) {
            this.doRPC(route, httpServletRequest, httpServletResponse);
        } else {
            String string = httpServletRequest.getParameter("_method");
            if (string == null) {
                string = httpServletRequest.getMethod();
            }
            if (string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("POST") || string.equalsIgnoreCase("PUT") || string.equalsIgnoreCase("DELETE")) {
                route.setMethod(string);
                this.doREST(route, httpServletRequest, httpServletResponse);
            } else {
                httpServletResponse.sendError(405, "Method Not Allowed");
                return;
            }
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Route route = this.preprocess(httpServletRequest, httpServletResponse);
        if (route == null) {
            return;
        }
        if ("rpc".equalsIgnoreCase((String)route.get("class"))) {
            httpServletResponse.addHeader("Allow", "POST");
            httpServletResponse.sendError(405, "Method Not Allowed");
        } else {
            this.doREST(route, httpServletRequest, httpServletResponse);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Route route = this.preprocess(httpServletRequest, httpServletResponse);
        if (route == null) {
            return;
        }
        if ("rpc".equalsIgnoreCase((String)route.get("class"))) {
            httpServletResponse.addHeader("Allow", "POST");
            httpServletResponse.sendError(405, "Method Not Allowed");
        } else {
            this.doREST(route, httpServletRequest, httpServletResponse);
        }
    }

    protected void doRPC(Route route, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        JSONInvoker jSONInvoker = new JSONInvoker(httpServletRequest, httpServletResponse);
        jSONInvoker.setLocale(httpServletRequest.getLocale());
        RpcRequest rpcRequest = null;
        Object object2 = null;
        int n = 0;
        String string = null;
        try {
            rpcRequest = jSONInvoker.parse((Reader)httpServletRequest.getReader(), RpcRequest.class);
            if (rpcRequest == null || rpcRequest.method == null || rpcRequest.params == null) {
                n = -32600;
                string = "Invalid Request.";
            } else {
                int n2 = rpcRequest.method.lastIndexOf(46);
                if (n2 <= 0 && n2 + 1 == rpcRequest.method.length()) {
                    throw new NoSuchMethodException(rpcRequest.method);
                }
                route.put("class", rpcRequest.method.substring(0, n2));
                object = this.container.getComponent(route.getComponentClass());
                if (object == null) {
                    throw new NoSuchMethodException(rpcRequest.method);
                }
                jSONInvoker.setContext(object);
                object2 = jSONInvoker.invoke(object, rpcRequest.method.substring(n2 + 1), rpcRequest.params);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.container.debug(classNotFoundException.getMessage());
            n = -32601;
            string = "Method not found.";
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.container.debug(noSuchMethodException.getMessage());
            n = -32601;
            string = "Method not found.";
        }
        catch (JSONConvertException jSONConvertException) {
            this.container.debug(jSONConvertException.getMessage());
            n = -32602;
            string = "Invalid params.";
        }
        catch (JSONParseException jSONParseException) {
            this.container.debug(jSONParseException.getMessage());
            n = -32700;
            string = "Parse error.";
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getCause();
            this.container.debug(((Throwable)object).toString());
            if (object instanceof IllegalStateException || object instanceof UnsupportedOperationException) {
                n = -32601;
                string = "Method not found.";
            } else if (object instanceof IllegalArgumentException) {
                n = -32602;
                string = "Invalid params.";
            } else {
                n = -32603;
                string = ((Throwable)object).getMessage();
            }
        }
        catch (Exception exception) {
            this.container.error(exception.getMessage(), exception);
            n = -32603;
            string = "Internal error.";
        }
        if (rpcRequest != null && rpcRequest.method != null && rpcRequest.params != null && rpcRequest.id == null) {
            httpServletResponse.setStatus(202);
            return;
        }
        httpServletResponse.setContentType("application/json");
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("result", object2);
        if (n == 0) {
            linkedHashMap.put("error", null);
        } else {
            object = new LinkedHashMap();
            object.put("code", n);
            object.put("message", string);
            linkedHashMap.put("error", object);
        }
        linkedHashMap.put("id", rpcRequest != null ? rpcRequest.id : null);
        object = httpServletResponse.getWriter();
        try {
            jSONInvoker.setContext(object2);
            jSONInvoker.setPrettyPrint(this.container.isDebugMode());
            jSONInvoker.format(linkedHashMap, (Appendable)object);
        }
        catch (Exception exception) {
            this.container.error(exception.getMessage(), exception);
            linkedHashMap.clear();
            linkedHashMap.put("result", null);
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            linkedHashMap2.put("code", -32603);
            linkedHashMap2.put("message", "Internal error.");
            linkedHashMap.put("error", linkedHashMap2);
            linkedHashMap.put("id", rpcRequest != null ? rpcRequest.id : null);
            jSONInvoker.format(linkedHashMap, (Appendable)object);
            return;
        }
    }

    protected void doREST(Route route, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = route.getMethod();
        int n = 200;
        String string2 = null;
        if ("get".equals(route.getMethod())) {
            string = "find";
            string2 = httpServletRequest.getParameter("callback");
        } else if ("post".equals(route.getMethod())) {
            string = "create";
            n = 201;
        } else if ("put".equals(route.getMethod())) {
            string = "update";
        } else if ("delte".equals(route.getMethod())) {
            string = "delete";
        }
        JSONInvoker jSONInvoker = new JSONInvoker(httpServletRequest, httpServletResponse);
        jSONInvoker.setLocale(httpServletRequest.getLocale());
        Object object2 = null;
        try {
            object = this.container.getComponent(route.getComponentClass());
            if (object == null) {
                httpServletResponse.sendError(404, "Not Found");
                return;
            }
            List<Object> list = null;
            if ("get".equals(route.getMethod())) {
                list = new ArrayList<Map<String, Object>>();
                Map<String, Object> map = WebServiceServlet.getParameterMap(httpServletRequest);
                map.putAll(route);
                list.add(map);
            } else {
                Object object3 = jSONInvoker.parse(httpServletRequest.getReader());
                if (object3 instanceof List) {
                    list = (List)object3;
                    Map<String, Object> map = WebServiceServlet.getParameterMap(httpServletRequest);
                    map.putAll(route);
                    list.add(map);
                } else if (object3 instanceof Map) {
                    Map map = (Map)object3;
                    map.putAll(WebServiceServlet.getParameterMap(httpServletRequest));
                    map.putAll(route);
                    list = new ArrayList();
                    list.add(map);
                } else {
                    throw new IllegalArgumentException("failed to convert parameters from JSON.");
                }
            }
            jSONInvoker.setContext(object);
            object2 = jSONInvoker.invoke(object, string, list);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.container.debug(classNotFoundException.getMessage());
            httpServletResponse.sendError(404, "Not Found");
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.container.debug(noSuchMethodException.getMessage());
            httpServletResponse.sendError(404, "Not Found");
            return;
        }
        catch (JSONConvertException jSONConvertException) {
            this.container.debug(jSONConvertException.getMessage());
            httpServletResponse.sendError(400, "Bad Request");
            return;
        }
        catch (JSONParseException jSONParseException) {
            this.container.debug(jSONParseException.getMessage());
            httpServletResponse.sendError(400, "Bad Request");
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            this.container.debug(throwable.toString());
            if (throwable instanceof IllegalStateException || throwable instanceof UnsupportedOperationException) {
                httpServletResponse.sendError(404, "Not Found");
            } else if (throwable instanceof IllegalArgumentException) {
                httpServletResponse.sendError(400, throwable.getMessage());
            } else {
                httpServletResponse.sendError(500, throwable.getMessage());
            }
            return;
        }
        catch (Exception exception) {
            this.container.error(exception.getMessage(), exception);
            httpServletResponse.sendError(500, "Internal Server Error");
            return;
        }
        try {
            if (object2 == null || object2 instanceof CharSequence || object2 instanceof Boolean || object2 instanceof Number || object2 instanceof Date) {
                if (n != 201) {
                    n = 204;
                }
                httpServletResponse.setStatus(n);
            } else {
                httpServletResponse.setContentType(string2 != null ? "text/javascript" : "application/json");
                object = httpServletResponse.getWriter();
                jSONInvoker.setPrettyPrint(this.container.isDebugMode());
                if (string2 != null) {
                    ((Writer)object).append(string2).append("(");
                }
                jSONInvoker.format(object2, (Appendable)object);
                if (string2 != null) {
                    ((Writer)object).append(");");
                }
            }
        }
        catch (Exception exception) {
            this.container.error(exception.getMessage(), exception);
            httpServletResponse.sendError(500, "Internal Server Error");
            return;
        }
    }

    private static Map<String, Object> getParameterMap(HttpServletRequest httpServletRequest) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            char c = '\u0000';
            Map<String, Object> map = linkedHashMap;
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == '.' || c2 == '[') {
                    String[] stringArray2 = string.substring(n, c == ']' ? i - 1 : i);
                    Object v = map.get(stringArray2);
                    if (!(v instanceof Map)) {
                        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
                        if (v != null) {
                            linkedHashMap2.put("", v);
                        }
                        map.put((String)stringArray2, linkedHashMap2);
                        map = linkedHashMap2;
                    } else {
                        map = (Map)v;
                    }
                    n = i + 1;
                }
                c = c2;
            }
            Object object = null;
            if (stringArray == null || stringArray.length == 0) {
                object = null;
            } else if (stringArray.length == 1) {
                object = stringArray[0];
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                for (String string2 : stringArray) {
                    arrayList.add(string2);
                }
                object = arrayList;
            }
            map.put(string.substring(n, c == ']' ? string.length() - 1 : string.length()), object);
        }
        return linkedHashMap;
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    private static String toLowerCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 1 && Character.isUpperCase(stringBuilder.charAt(0)) && Character.isLowerCase(stringBuilder.charAt(1))) {
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JSONInvoker
    extends JSON {
        private HttpServletRequest request;
        private HttpServletResponse response;

        public JSONInvoker(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
        }

        public Object invoke(Object object, String string, List<Object> list) throws Exception {
            Object[] objectArray;
            Object object2;
            if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            string = WebServiceServlet.toLowerCamel(string);
            Class<?> clazz = object.getClass();
            Method method = null;
            Method method2 = null;
            Method method3 = null;
            int n = 0;
            if (((WebServiceServlet)WebServiceServlet.this).container.init == null) {
                ++n;
            }
            if (((WebServiceServlet)WebServiceServlet.this).container.destroy == null) {
                ++n;
            }
            for (Method method4 : clazz.getMethods()) {
                if (Modifier.isStatic(method4.getModifiers())) continue;
                if (((WebServiceServlet)WebServiceServlet.this).container.init != null && method4.getName().equals(((WebServiceServlet)WebServiceServlet.this).container.init)) {
                    method = method4;
                    ++n;
                } else if (((WebServiceServlet)WebServiceServlet.this).container.destroy != null && method4.getName().equals(((WebServiceServlet)WebServiceServlet.this).container.destroy)) {
                    method3 = method4;
                    ++n;
                } else if (method4.getName().equals(string)) {
                    method2 = method4;
                    ++n;
                }
                if (n > 3) break;
            }
            if (method2 == null || WebServiceServlet.this.container.limit(clazz, method2)) {
                object2 = new StringBuilder(clazz.getName());
                ((StringBuilder)object2).append('#').append(string).append('(');
                String string2 = JSON.encode(list);
                ((StringBuilder)object2).append(string2, 1, string2.length() - 1);
                ((StringBuilder)object2).append(')');
                throw new NoSuchMethodException("method missing: " + ((StringBuilder)object2).toString());
            }
            object2 = method2.getGenericParameterTypes();
            Object[] objectArray2 = new Object[((Object)object2).length];
            int n2 = Math.min(list.size(), objectArray2.length);
            for (int i = 0; i < n2; ++i) {
                objectArray2[i] = this.convert(list.get(i), (Type)object2[i]);
            }
            if (method != null) {
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length > 0) {
                    objectArray = new Object[classArray.length];
                    for (int i = 0; i < classArray.length; ++i) {
                        objectArray[i] = this.get(classArray[i]);
                    }
                    method.invoke(object, objectArray);
                } else {
                    method.invoke(object, new Object[0]);
                }
            }
            Object object3 = method2.invoke(object, objectArray2);
            if (method3 != null) {
                objectArray = method3.getParameterTypes();
                if (objectArray.length > 0) {
                    Object[] objectArray3 = new Object[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray3[i] = this.get((Type)objectArray[i]);
                    }
                    method3.invoke(object, objectArray3);
                } else {
                    method3.invoke(object, new Object[0]);
                }
            }
            return object3;
        }

        private Object get(Type type) {
            Class clazz;
            Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
            if (clazz != null) {
                if (ServletRequest.class.equals((Object)clazz) || HttpServletRequest.class.equals((Object)clazz)) {
                    return this.request;
                }
                if (ServletResponse.class.equals((Object)clazz) || HttpServletResponse.class.equals((Object)clazz)) {
                    return this.response;
                }
                if (ServletContext.class.equals((Object)clazz)) {
                    return WebServiceServlet.this.getServletContext();
                }
                if (HttpSession.class.equals((Object)clazz)) {
                    return this.request.getSession(true);
                }
            }
            return null;
        }
    }

    class RpcRequest {
        public String method;
        public List params;
        public Object id;

        RpcRequest() {
        }
    }

    class Config {
        public Class<? extends Container> container;
        public String encoding;
        public Boolean expire;
        public Map<String, String> mappings;
        public Map<String, Pattern> definitions;

        Config() {
        }
    }
}

