/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.dao;

import java.util.List;

/**
 * Rialto のコードラベル (rialto.widget.codeLabel) で使用するコードと
 * ラベルの対応表を取得するための DAO です。
 * 
 * @see <a href="http://rialto.improve-technologies.com/js/javascriptDocV1/html/codeLib.html">
 *      RIALTO javascript documentation</a>
 */
public interface CodeLabelDAO {

	/**
	 * コード／ラベル対応表を取得します。
	 * 
	 * @param tableName
	 *            テーブル名
	 * @param codeField
	 *            コードに使用するフィールド名
	 * @param labelField
	 *            ラベルに使用するフィールド名
	 * @param keyword
	 *            キーワード
	 * @return コードとラベルから構成されるオブジェクトの配列を
	 *          要素とするリスト
	 */
	List<Object[]> find(String tableName, String codeField, String labelField,
			String keyword);

}
