/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.dao;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.stereotype.Repository;

/**
 * Spring の JPA 連携機能を利用した {@link CodeLabelDAO} の実装です。
 */
@Repository
public class CodeLabelDAOJpaImpl extends JpaDaoSupport implements CodeLabelDAO {

	/**
	 * アノテーション情報を利用して、JPA エンティティマネージャへの
	 * 依存性を DI コンテナ側から自動的に注入するための設定メソッド
	 * です。
	 * 
	 * @param entityManager
	 *            JPA エンティティマネージャ
	 */
	@PersistenceContext
	public void setEntityManager2(EntityManager entityManager) {
		super.setEntityManager(entityManager);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.dao.GenericDAO#findCodeAndLabel(java.lang.String,
	 *      java.lang.String, java.lang.String, java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public List<Object[]> find(String tableName, String codeField,
			String labelField, String keyword) {
		EntityManager em = getJpaTemplate().getEntityManager();

		/* JPA のネイティブクエリ (SQL 文) を組み立てる */
		StringBuffer buf = new StringBuffer("SELECT ")
			.append(codeField)
			.append(", ")
			.append(labelField)
			.append(" FROM ")
			.append(tableName);

		/* キーワードが指定されている場合は WHERE 節を追加 */
		if (keyword != null && keyword.length() > 0) {
			buf.append(" WHERE ")
				.append(codeField)
				.append(" LIKE ?1 OR ")
				.append(labelField)
				.append(" LIKE ?1");
			return em.createNativeQuery(buf.toString()).setParameter(1,
					"%" + keyword + "%").getResultList();
		} else {
			return em.createNativeQuery(buf.toString()).getResultList();
		}
	}

}
