/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.entity;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * フルーツショップの顧客情報を表すエンティティです。
 */
@Entity
@Table(name = "fruitshop_customers")
public class FruitShopCustomer {

	/** 顧客コード */
	@Id
	@Column(name = "customer_id")
	private String customerId;

	/** 顧客名 */
	private String name;

	/** 電話番号 */
	private String phone;

	/** FAX 番号 */
	private String fax;

	/** 郵便番号 */
	private String zip;

	/** 住所 */
	private String address;

	/** 担当者名 */
	@Column(name = "contact_person")
	private String contactPerson;

	/** この顧客情報が注文した受注情報のリスト */
	@OneToMany(mappedBy = "customer")
	private List<FruitShopOrder> orders;

	public String getCustomerId() {
		return customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getContactPerson() {
		return contactPerson;
	}

	public void setContactPerson(String contactPerson) {
		this.contactPerson = contactPerson;
	}

	public List<FruitShopOrder> getOrders() {
		return orders;
	}

	public void setOrders(List<FruitShopOrder> orders) {
		this.orders = orders;
	}

}
