/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * フルーツショップの受注情報を表すエンティティです。
 */
@Entity
@Table(name = "fruitshop_orders")
public class FruitShopOrder {

	/** 受注コード */
	@Id
	@Column(name = "order_id")
	private String orderId;

	/** 顧客コード */
	@Column(name = "customer_id")
	private String customerId;

	/** この受注情報の発生元となる顧客 */
	@ManyToOne
	@JoinColumn(name = "customer_id")
	private FruitShopCustomer customer;

	/** 受注日時 */
	@Column(name = "order_date")
	private Date orderDate;

	/** 合計金額 */
	private int total;

	/** 受注明細のリスト */
	@OneToMany(mappedBy = "order", cascade = { CascadeType.ALL })
	private List<FruitShopOrderDetail> details;

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getCustomerId() {
		return customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public FruitShopCustomer getCustomer() {
		return customer;
	}

	public void setCustomer(FruitShopCustomer customer) {
		this.customer = customer;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public int getTotal() {
		return total;
	}

	public void setTotal(int total) {
		this.total = total;
	}

	public List<FruitShopOrderDetail> getDetails() {
		return details;
	}

	public void setDetails(List<FruitShopOrderDetail> details) {
		this.details = details;
	}

}
