/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.gourmet.controller;

import java.io.InputStream;

import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;

import jp.sf.maskat.sample.gourmet.dto.SearchRestaurantRequest;
import jp.sf.maskat.sample.gourmet.dto.SearchRestaurantResponse;
import jp.sf.maskat.sample.gourmet.service.GourmetSearchService;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * レストラン検索アプリケーションから送信されるリモートイベントを
 * 処理するためのコントローラです。
 */
@Controller
public class GourmetController {

	/** レストラン検索サービス */
	private GourmetSearchService service;

	/**
	 * レストラン検索の業務ロジックを提供するサービスオブジェクトを
	 * 設定します。
	 * 
	 * @param service レストラン検索サービス
	 */
	@Resource
	public void setService(GourmetSearchService service) {
		this.service = service;
	}

	@RequestMapping("/sample/gourmet/search_restaurant.do")
	public String search(InputStream stream, ModelMap model) throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(SearchRestaurantRequest.class);
		SearchRestaurantRequest command = (SearchRestaurantRequest) context
				.createUnmarshaller().unmarshal(stream);
		SearchRestaurantResponse result = service.search(command);

		model.addAttribute(result);
		return "searchRestaurantResponse";
	}

}
