/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.gourmet.dao;

import java.util.List;

import jp.sf.maskat.dao.GenericDAO;
import jp.sf.maskat.sample.gourmet.entity.GourmetRestaurant;

import org.springframework.dao.DataAccessException;

/**
 * レストラン情報 ({@link GourmetRestaurant}) を管理する DAO です。
 */
public interface GourmetRestaurantDAO extends
		GenericDAO<GourmetRestaurant, String> {

	public List<GourmetRestaurant> find(Boolean western, Boolean japanese,
			Boolean chinese, Integer budgetLowerLimit,
			Integer budgetUpperLimit, Boolean withCoupon)
			throws DataAccessException;

}
