/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.gourmet.service;

import java.util.List;

import javax.annotation.Resource;

import jp.sf.maskat.sample.gourmet.dao.GourmetRestaurantDAO;
import jp.sf.maskat.sample.gourmet.dto.SearchRestaurantRequest;
import jp.sf.maskat.sample.gourmet.dto.SearchRestaurantResponse;
import jp.sf.maskat.sample.gourmet.entity.GourmetRestaurant;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * POJO を用いた {@link GourmetService} の実装です。
 */
@Service
@Transactional
public class GourmetServiceImpl implements GourmetSearchService {

	/** レストラン情報を管理する DAO */
	private GourmetRestaurantDAO restaurantDAO;

	@Resource
	public void setRestaurantDAO(GourmetRestaurantDAO restaurantDAO) {
		this.restaurantDAO = restaurantDAO;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.sample.gourmet.service.GourmetSearchService#search(jp.sf.maskat.sample.gourmet.dto.SearchRestaurantRequest)
	 */
	public SearchRestaurantResponse search(SearchRestaurantRequest command) {
		List<GourmetRestaurant> restaurants = restaurantDAO.find(
				command.getWestern(),
				command.getJapanese(),
				command.getChinese(),
				command.getBudgetLowerLimit(),
				command.getBudgetUpperLimit(),
				command.getCoupon());

		return new SearchRestaurantResponse(restaurants);
	}

}
