/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.petstore.controller;

import java.io.InputStream;

import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;

import jp.sf.maskat.sample.petstore.dto.SearchItemRequest;
import jp.sf.maskat.sample.petstore.dto.SearchItemResponse;
import jp.sf.maskat.sample.petstore.dto.SearchProductRequest;
import jp.sf.maskat.sample.petstore.dto.SearchProductResponse;
import jp.sf.maskat.sample.petstore.service.PetStoreCatalogService;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * ペットストアアプリケーションから送信されるリモートイベントを処理
 * するためのコントローラです。
 */
@Controller
public class PetStoreController {

	/** ペットカタログ検索サービス */
	private PetStoreCatalogService catalogService;

	/**
	 * ペットカタログ検索の業務ロジックを提供するサービスオブジェクト
	 * を設定します。
	 * 
	 * @param catalogService
	 *            ペットカタログ検索サービス
	 */
	@Resource
	public void setCatalogService(PetStoreCatalogService catalogService) {
		this.catalogService = catalogService;
	}

	@RequestMapping("/sample/petstore/search_product.do")
	public String searchProduct(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(SearchProductRequest.class);
		SearchProductRequest command = (SearchProductRequest) context
				.createUnmarshaller().unmarshal(stream);
		SearchProductResponse result = catalogService.searchProduct(command);

		model.addAttribute(result);
		return "searchProductResponse";
	}

	@RequestMapping("/sample/petstore/search_item.do")
	public String searchItem(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(SearchItemRequest.class);
		SearchItemRequest command = (SearchItemRequest) context
				.createUnmarshaller().unmarshal(stream);
		SearchItemResponse result = catalogService.searchItem(command);

		model.addAttribute(result);
		return "searchItemResponse";
	}

}
