/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.petstore.dao;

import java.util.List;

import jp.sf.maskat.dao.GenericDAO;
import jp.sf.maskat.sample.petstore.entity.PetStoreItem;

import org.springframework.dao.DataAccessException;

/**
 * 在庫情報 ({@link PetStoreItem}) を管理する DAO です。
 */
public interface PetStoreItemDAO extends GenericDAO<PetStoreItem, String> {

	/**
	 * 指定した商品コードに該当する在庫情報のリストを取得します。
	 * 
	 * @param productId
	 *            商品ID
	 * @return 在庫情報のリスト
	 * @throws DataAccessException
	 *             データアクセス中に例外が発生した場合
	 */
	List<PetStoreItem> findAllByProductId(String productId)
			throws DataAccessException;

}
