/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.petstore.dao;

import java.util.List;

import jp.sf.maskat.dao.GenericDAO;
import jp.sf.maskat.sample.petstore.entity.PetStoreProduct;

import org.springframework.dao.DataAccessException;

/**
 * 商品情報 ({@link PetStoreProduct}) を管理する DAO です。
 */
public interface PetStoreProductDAO extends GenericDAO<PetStoreProduct, String> {

	/**
	 * 指定したカテゴリに該当する商品情報のリストを取得します。
	 * 
	 * @param categoryId
	 *            カテゴリID
	 * @return 商品情報のリスト
	 * @throws DataAccessException
	 *             データアクセス中に例外が発生した場合
	 */
	List<PetStoreProduct> findAllByCategoryId(String categoryId)
			throws DataAccessException;

}
