/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.petstore.dto;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

import jp.sf.maskat.sample.petstore.entity.PetStoreItem;

@XmlRootElement(name = "response")
@XmlAccessorType(XmlAccessType.FIELD)
public class SearchItemResponse {

	@XmlElementWrapper(name = "items")
	@XmlElement(name = "item")
	private List<PetStoreItem> items;

	public SearchItemResponse(List<PetStoreItem> items) {
		super();
		this.items = items;
	}

	public SearchItemResponse() {
		this(null);
	}

	public List<PetStoreItem> getItems() {
		return items;
	}

	public void setItems(List<PetStoreItem> items) {
		this.items = items;
	}

}
