/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.petstore.service;

import java.util.List;

import javax.annotation.Resource;

import jp.sf.maskat.sample.petstore.dao.PetStoreItemDAO;
import jp.sf.maskat.sample.petstore.dao.PetStoreProductDAO;
import jp.sf.maskat.sample.petstore.dto.SearchItemRequest;
import jp.sf.maskat.sample.petstore.dto.SearchItemResponse;
import jp.sf.maskat.sample.petstore.dto.SearchProductRequest;
import jp.sf.maskat.sample.petstore.dto.SearchProductResponse;
import jp.sf.maskat.sample.petstore.entity.PetStoreItem;
import jp.sf.maskat.sample.petstore.entity.PetStoreProduct;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * POJO を用いた {@link PetStoreCatalogService} の実装です。
 */
@Service
@Transactional
public class PetStoreCatalogServiceImpl implements PetStoreCatalogService {

	/** 商品情報を管理する DAO */
	private PetStoreProductDAO productDAO;

	/** 在庫情報を管理する DAO */
	private PetStoreItemDAO itemDAO;

	/**
	 * 商品情報を管理する DAO を設定します。
	 * 
	 * @param productDAO
	 *            商品情報を管理する DAO
	 */
	@Resource
	public void setProductDAO(PetStoreProductDAO productDAO) {
		this.productDAO = productDAO;
	}

	/**
	 * 在庫情報を管理する DAO を設定します。
	 * 
	 * @param itemDAO
	 *            在庫情報を管理する DAO
	 */
	@Resource
	public void setItemDAO(PetStoreItemDAO itemDAO) {
		this.itemDAO = itemDAO;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.sample.petstore.service.PetStoreCatalogService#searchProduct(jp.sf.maskat.sample.petstore.dto.SearchProductRequest)
	 */
	public SearchProductResponse searchProduct(SearchProductRequest command) {
		List<PetStoreProduct> products = productDAO.findAllByCategoryId(command
				.getCategoryId());
		return new SearchProductResponse(products);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.sample.petstore.service.PetStoreCatalogService#searchItem(jp.sf.maskat.sample.petstore.dto.SearchItemRequest)
	 */
	public SearchItemResponse searchItem(SearchItemRequest command) {
		List<PetStoreItem> items = itemDAO.findAllByProductId(command
				.getProductId());
		return new SearchItemResponse(items);
	}

}
