/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.google.GooglePlugin")
	.extend("maskat.core.Plugin", {

	_static: {
		initialize: function() {
			maskat.core.Plugin.register(this);
		}
	},

	getPluginId: function() {
		return "google";
	},

	getVersion: function() {
		return "1.0.0.v20080521";
	},

	isLoaded: function() {
		return typeof(google) != "undefined" && typeof(GMap2) != "undefined";
	},

	load: function() {
		maskat.app.loadJavaScript("http://www.google.com/jsapi?key="
			+ this.getProperty("key"), true);
		this.loader = new maskat.lang.Thread(this, this.loadModules, null, 100);
		this.loader.start();
	},

	loadModules: function() {
		if (typeof(google) != "undefined" && typeof(google.load) == "function") {
			this.loader.stop();
			google.load("maps", "2", { callback: function() {} });
		}
	},
	
	start: function() {
		var reader = maskat.layout.LayoutXMLReader.getInstance();
		var library = new maskat.widget.google.GoogleWidgetLibrary();
		reader.addWidgetLibrary(library);
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.google.GoogleWidgetLibrary")
	.extend("maskat.layout.WidgetLibrary", {

	getBindingConfiguration: function() {
		return {
			googleMap: {
				type: maskat.widget.google.Map2Wrapper,
				attributes: {
					name: { type: "string", required: true },
					top: { type: "number", required: true },
					left: { type: "number", required: true },
					width: { type: "number" },
					height: { type: "number" },
					initialLongitude: { type: "number", defaultValue: 0 },
					initialLatitude: { type: "number", defaultValue: 0 },
					initialZoomLevel: { type: "number", defaultValue: 10 },
					mapControl: { type:"enum", values: ["large","small"] },
					typeControl: { type:"boolean" },
					doubleClickZoom: { type:"boolean" },
					continuousZoom: { type:"boolean" }
				}
			}
		};
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.google.Map2Wrapper")
	.extend("maskat.layout.Widget", {

    createWidget: function(parent){
		var div = document.createElement("div");
		div.style.position = "absolute";
		div.style.left = this.left + "px";
		div.style.top = this.top + "px";
		div.style.width = this.width + "px";
		div.style.height = this.height + "px";

		parent.getElement().appendChild(div);
		this.element = div;

		var map = new google.maps.Map2(div);
		var latlng = new google.maps.LatLng(this.initialLatitude, this.initialLongitude);
		map.setCenter(latlng, this.initialZoomLevel);

		switch (this.mapControl) {
		case "large":
			map.addControl(new google.maps.LargeMapControl());
			break;
		case "small":
			map.addControl(new google.maps.SmallMapControl());
			break;
		default:
			break;
		}

		if (this.typeControl) {
			map.addControl(new google.maps.MapTypeControl());
		}

		if (this.doubleClickZoom){
			map.enableDoubleClickZoom();
		} else {
			map.disableDoubleClickZoom();
    	}

		if (this.continuousZoom){
	    	map.enableContinuousZoom();
	    }

		this.map = map;
		return map;
    },

	getWidgetId: function(){
		return this.name;
	},

	getWidget: function(){
		return this.map;
	},

	getValue: function(key) {
		if (key && this.getters[key]) {
			return this.getters[key].call(this);
		}
		return this.map.getCenter();
	},

	getters: {
		getCenter: function() {
			return this.map.getCenter();
		}
	},

	setValue: function(value, key) {
		if (key && this.setters[key]) {
			this.setters[key].call(this, value);
		} else {
			this.map.setCenter(new google.maps.LatLng(value.lat, value.lng));
		}
	},
	
	setters: {
		setCenter: function(value) {
			this.map.setCenter(new google.maps.LatLng(value.lat, value.lng));
		},

		panTo: function(value) {
			this.map.panTo(new google.maps.LatLng(value.lat, value.lng));
		},

		openInfoWindow: function(value) {
			var latlng = new google.maps.LatLng(value.lat, value.lng);
			var text = document.createTextNode(value.text);
			this.map.openInfoWindow(latlng, text);
		},

		addMarker: function(value) {
			var latlng = new google.maps.LatLng(value.lat, value.lng);
			var marker = new google.maps.Marker(latlng);
			google.maps.Event.addListener(marker, "click", function() {
				marker.openInfoWindow(value.text);
			});
			this.map.addOverlay(marker);
		},

		setMarkers: function(values) {
			this.map.clearOverlays();
		
			if (values && values instanceof Array) {
				for (var i = 0; i < values.length; i++) {
					this.setValue(values[i], "addMarker");
				}
			}
		}
	}

});
