/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core;

import java.util.List;
import java.util.Map;

/**
 * An instance of this class represents definition node.
 * <code>IBasicDef</code>s form a tree.
 * The children should have orders, so have indices.
 * The children are not required to be of the same type.
 */
public interface MaskatElement extends Cloneable {

	/**
	 * BasicDefs should have its parent reference. 
	 * For example: Child could see its parent so that it could delete itself
	 * from its parent. 
	 * Note: the returned object of getParentDef may not hold this "child"
	 * object as a child!!! For example, the child is removed from the parent,
	 * but the parentDef property is not set to null.
	 * 
	 * @see jp.sf.maskat.ui.views.properties.DeleteChildCommand
	 * 
	 */
	public MaskatElement getParent();

	public void setParent(MaskatElement parent);
	
	public List getChildren();

	public void addChild(Object child);

	public void removeChild(Object obj);

	public void removeAllChildren();
	
	public void removeAllByType(Class clazz);

	public void accept(MaskatElementVisitor visitor);

	public Object clone() throws CloneNotSupportedException;
	
	public List getAllDescendants(MaskatElement parent, Class descendantClass);

	public Map getDefaultValues();
	
	public Object getChildByTypeIdx(Class clazz, int idx);

	public int getChildIdx(Object child);

	public void addChildToIdx(Object child, int idx);

	public List getTypedChildren(Class clazz);
}
