/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Component extends AbstractEventElement {
	
	private String id;

	private Map events;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void addChild(Object child) {
		super.addChild(child);
		if (child instanceof Event) {
			addEvent((Event) child);
		}
	}
	
	private void addEvent(Event event) {
		if (events == null) {
			events = new HashMap();
		}
		events.put(event.getId(), event);
	}

	public Event removeEvent(String id) {
		return (Event) events.remove(id);
	}

	public Event findEvent(String id) {
		return (events == null) ? null : (Event) events.get(id);
	}
	
	public void setEvent(Event event) {
		int index = getChildIndex(event);
		if (index != -1) {
			List list = getChildren();
			list.set(index, event);
			event.setParent(this);
			//addChildToIdx(event, index);
			addEvent(event);
		} else {
			addChild(event);
		}
	}
	
	private int getChildIndex(Event event) {
		List list = getChildren();
		for (int i = 0; i < list.size(); i++) {
			Object child = list.get(i);
			if (child instanceof Event) {
				if (event.getId().equals(((Event) child).getId())) {
					return i;
				}
			}
		}
		return -1;
	}
	
	
	
	public boolean hasEvents() {
		return (events == null || events.size() == 0) ? false : true;
	}
	
	public boolean hasEnabledEvents() {
		if (events == null) {
			return false;
		}
		Iterator it = events.values().iterator();
		while (it != null && it.hasNext()) {
			if (((Event)it.next()).isEnable()) {
				return true;
			}
		}
		return false;
	}

	public Event[] getAllEvents() {
		if (events == null) {
			return null;
		}
		return (Event[]) events.values().toArray(new Event[0]);
	}
}
