/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

public class Param extends AbstractEventElement {
	
	public static final boolean SOAP_DEFAULT = false;

	private String rootNode;

	private String ns;

	private boolean soap = SOAP_DEFAULT;

	private boolean enable;
	
	public Param() {
		this(true);
	}

	public Param(boolean enable) {
		this.enable = enable;
	}

	public String getNs() {
		return ns;
	}

	public void setNs(String ns) {
		this.ns = ns;
	}

	public String getRootNode() {
		return rootNode;
	}

	public void setRootNode(String rootNode) {
		this.rootNode = rootNode;
	}

	public boolean isSoap() {
		return soap;
	}

	public void setSoap(boolean soap) {
		this.soap = soap;
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public Source[] getSources() {
		return (Source[]) getTypedChildren(Source.class).toArray(new Source[0]);
	}

	public void removeAllSources() {
		Source[] sources = getSources();
		for (int i = 0; i < sources.length; i++) {
			removeChild(sources[i]);
		}
	}
}
